/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.content.ContentResolver;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Build;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.widget.ImageView;
import com.instabug.library.Instabug;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.util.BitmapWorkerTask;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BitmapUtils {
    public static int getInMemoryByteSizeOfBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        if (Build.VERSION.SDK_INT >= 19) {
            return bitmap.getAllocationByteCount();
        }
        if (Build.VERSION.SDK_INT >= 12) {
            return bitmap.getByteCount();
        }
        return bitmap.getRowBytes() * bitmap.getHeight();
    }

    public static int getOnDiskByteSizeOfBitmap(Bitmap bitmap) {
        if (bitmap == null) {
            return 0;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray().length;
    }

    public static Bitmap getBitmapFromFilePath(@NonNull String object) {
        object = Uri.fromFile((File)new File((String)object));
        Bitmap bitmap = null;
        try {
            bitmap = MediaStore.Images.Media.getBitmap((ContentResolver)Instabug.getApplicationContext().getContentResolver(), (Uri)object);
        }
        catch (IOException iOException) {
            object = iOException;
            iOException.printStackTrace();
            InstabugSDKLogger.e(BitmapUtils.class, "getBitmapFromFilePath returns null because of " + ((Throwable)object).getMessage());
        }
        return bitmap;
    }

    public static void compressBitmapAndSave(@NonNull File file) {
        try {
            BitmapFactory.Options options = new BitmapFactory.Options();
            new BitmapFactory.Options().inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options);
            int n = 1;
            while (options.outWidth / n / 2 >= 900 && options.outHeight / n / 2 >= 900) {
                n <<= 1;
            }
            options = new BitmapFactory.Options();
            new BitmapFactory.Options().inSampleSize = n;
            options = BitmapFactory.decodeStream((InputStream)new FileInputStream(file), null, (BitmapFactory.Options)options);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            options.compress(BitmapUtils.getImageMimeType(file), 100, (OutputStream)fileOutputStream);
            options.recycle();
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            FileNotFoundException fileNotFoundException2 = fileNotFoundException;
            fileNotFoundException.printStackTrace();
            InstabugSDKLogger.e(BitmapUtils.class, "compressBitmapAndSave bitmap doesn't compressed correctly " + fileNotFoundException2.getMessage());
            return;
        }
    }

    private static Bitmap.CompressFormat getImageMimeType(File file) {
        if (file.getName().contains("png")) {
            return Bitmap.CompressFormat.PNG;
        }
        return Bitmap.CompressFormat.JPEG;
    }

    public static void loadBitmap(String string2, ImageView object) {
        object = new BitmapWorkerTask((ImageView)object);
        object.execute((Object[])new String[]{string2});
    }

    public static void loadBitmap(String string2, ImageView object, float f2, float f3) {
        object = new BitmapWorkerTask((ImageView)object, f2, f3);
        object.execute((Object[])new String[]{string2});
    }

    public static void loadBitmap(String string2, ImageView object, BitmapWorkerTask.OnImageLoadedListener onImageLoadedListener) {
        object = new BitmapWorkerTask((ImageView)object, onImageLoadedListener);
        object.execute((Object[])new String[]{string2});
    }

    public static int calculateInSampleSize(BitmapFactory.Options options) {
        int n = options.outHeight;
        int n2 = options.outWidth;
        int n3 = 1;
        if (n > 500 || n2 > 500) {
            n /= 2;
            n2 /= 2;
            while (n / n3 >= 500 && n2 / n3 >= 500) {
                n3 <<= 1;
            }
        }
        return n3;
    }

    public static Bitmap decodeSampledBitmapFromLocalPath(String string2) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        new BitmapFactory.Options().inJustDecodeBounds = true;
        BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
        options.inSampleSize = BitmapUtils.calculateInSampleSize(options);
        options.inJustDecodeBounds = false;
        return BitmapFactory.decodeFile((String)string2, (BitmapFactory.Options)options);
    }

    public static Bitmap resizeBitmap(Bitmap bitmap, float f2, float f3) {
        if (bitmap == null) {
            return null;
        }
        if (f2 == 0.0f && f3 == 0.0f) {
            return bitmap;
        }
        Bitmap bitmap2 = Bitmap.createBitmap((int)((int)f2), (int)((int)f3), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (bitmap.getWidth() < bitmap.getHeight() && f2 > f3) {
            return bitmap;
        }
        if (bitmap.getWidth() > bitmap.getHeight() && f2 < f3) {
            return bitmap;
        }
        Canvas canvas = new Canvas(bitmap2);
        Matrix matrix = new Matrix();
        if (bitmap.getWidth() < bitmap.getHeight()) {
            matrix.setScale(f2 / (float)bitmap.getWidth(), f3 / (float)bitmap.getHeight());
        } else {
            matrix.setScale(f3 / (float)bitmap.getHeight(), f2 / (float)bitmap.getWidth());
        }
        canvas.drawBitmap(bitmap, matrix, new Paint());
        return bitmap2;
    }

    private static Bitmap resizeBitmap(Bitmap bitmap, int n) {
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        if (n3 > n2) {
            n3 = n;
            n2 = n / 2;
        } else {
            n2 = n;
            n3 = n / 2;
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)false);
    }

    public static void saveBitmapAsPNG(Bitmap bitmap, int n, File file, String object, a a2) {
        file = new File(file, (String)object + "_" + System.currentTimeMillis() + ".png");
        InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + file.toString());
        try {
            object = new BufferedOutputStream(new FileOutputStream(file));
            bitmap.compress(Bitmap.CompressFormat.PNG, n, (OutputStream)object);
            ((FilterOutputStream)object).close();
            bitmap = Uri.fromFile((File)file);
            if (bitmap == null) {
                a2.a(new Throwable("Uri equal null"));
                return;
            }
            a2.a((Uri)bitmap);
        }
        catch (IOException iOException) {
            a2.a(iOException);
        }
    }

    public static void saveBitmap(Bitmap bitmap, Context object, a a2) {
        object = DiskUtils.getInstabugDirectory((Context)object);
        object = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
        InstabugSDKLogger.v(AttachmentsUtility.class, "image path: " + ((File)object).toString());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream((File)object));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bufferedOutputStream);
            bufferedOutputStream.close();
            bitmap = Uri.fromFile((File)object);
            if (bitmap == null) {
                a2.a(new Throwable("Uri equal null"));
                return;
            }
            a2.a((Uri)bitmap);
        }
        catch (IOException iOException) {
            a2.a(iOException);
        }
    }

    public static void saveBitmap(Bitmap bitmap, Uri uri, Context context) {
        try {
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, context.getContentResolver().openOutputStream(Uri.fromFile((File)new File(uri.getPath()))));
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            InstabugSDKLogger.e(BitmapUtils.class, fileNotFoundException.getMessage(), fileNotFoundException);
            return;
        }
    }

    public static void saveBitmap(Bitmap bitmap, File file, a a2) {
        file = new File(file, "frame_" + System.currentTimeMillis() + "_.jpg");
        InstabugSDKLogger.v(AttachmentsUtility.class, "video frame path: " + file.toString());
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            int n = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
            if (n > 640) {
                bitmap = BitmapUtils.resizeBitmap(bitmap, 640);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
            } else {
                bitmap = BitmapUtils.resizeBitmap(bitmap, 320);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)bufferedOutputStream);
            }
            bufferedOutputStream.close();
            bitmap = Uri.fromFile((File)file);
            if (bitmap == null) {
                a2.a(new Throwable("Uri equal null"));
                return;
            }
            a2.a((Uri)bitmap);
        }
        catch (IOException iOException) {
            a2.a(iOException);
        }
    }

    public static interface a {
        public void a(Uri var1);

        public void a(Throwable var1);
    }
}

