/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.webkit.MimeTypeMap;
import com.instabug.library.internal.storage.cache.Cacheable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Attachment
implements Cacheable,
Serializable {
    static final String KEY_NAME = "name";
    static final String KEY_LOCALE_PATH = "local_path";
    static final String KEY_URL = "url";
    static final String KEY_TYPE = "type";
    static final String KEY_ATTACHMENT_STATE = "attachment_state";
    static final String KEY_VIDEO_ENCODED = "video_encoded";
    static final String KEY_DURATION = "duration";
    private String name;
    private String localPath;
    private String url;
    private Type type;
    private AttachmentState attachmentState;
    private boolean isVideoEncoded = false;
    private String duration;
    private boolean shouldAnimate = true;

    public Attachment() {
        this.setType(Type.NOT_AVAILABLE);
        this.setAttachmentState(AttachmentState.NOT_AVAILABLE);
    }

    public static JSONArray toJson(ArrayList<Attachment> arrayList) throws JSONException {
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < arrayList.size(); ++i) {
            jSONArray.put((Object)new JSONObject(arrayList.get(i).toJson()));
        }
        return jSONArray;
    }

    public static ArrayList<Attachment> fromJson(JSONArray jSONArray) throws JSONException {
        ArrayList<Attachment> arrayList = new ArrayList<Attachment>();
        for (int i = 0; i < jSONArray.length(); ++i) {
            Attachment attachment = new Attachment();
            attachment.fromJson(jSONArray.getJSONObject(i).toString());
            arrayList.add(attachment);
        }
        return arrayList;
    }

    public String getName() {
        return this.name;
    }

    public Attachment setName(String string2) {
        this.name = string2;
        return this;
    }

    public String getLocalPath() {
        return this.localPath;
    }

    public Attachment setLocalPath(String string2) {
        this.localPath = string2;
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public Attachment setUrl(String string2) {
        this.url = string2;
        return this;
    }

    public Type getType() {
        return this.type;
    }

    public Attachment setType(Type type) {
        this.type = type;
        return this;
    }

    public boolean shouldAnimate() {
        return this.shouldAnimate;
    }

    public void setShouldAnimate(boolean bl) {
        this.shouldAnimate = bl;
    }

    public boolean isVideoEncoded() {
        return this.isVideoEncoded;
    }

    public Attachment setVideoEncoded(boolean bl) {
        this.isVideoEncoded = bl;
        return this;
    }

    public String getFileType() {
        String string2 = MimeTypeMap.getFileExtensionFromUrl((String)this.getName());
        if (string2 != null && !string2.equals("")) {
            string2 = MimeTypeMap.getSingleton().getMimeTypeFromExtension(string2);
            if (string2 != null && !string2.equals("")) {
                return string2;
            }
            return this.getType().toString();
        }
        return this.getType().toString();
    }

    public AttachmentState getAttachmentState() {
        return this.attachmentState;
    }

    public Attachment setAttachmentState(AttachmentState attachmentState) {
        this.attachmentState = attachmentState;
        return this;
    }

    public String getDuration() {
        return this.duration;
    }

    public void setDuration(String string2) {
        this.duration = string2;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put(KEY_NAME, (Object)this.getName()).put(KEY_LOCALE_PATH, (Object)this.getLocalPath()).put(KEY_URL, (Object)this.getUrl()).put(KEY_TYPE, (Object)this.getType().toString()).put(KEY_ATTACHMENT_STATE, (Object)this.getAttachmentState().toString()).put(KEY_VIDEO_ENCODED, this.isVideoEncoded()).put(KEY_DURATION, (Object)this.getDuration());
        return jSONObject.toString();
    }

    @Override
    public void fromJson(String string2) throws JSONException {
        if ((string2 = new JSONObject(string2)).has(KEY_NAME)) {
            this.setName(string2.getString(KEY_NAME));
        }
        if (string2.has(KEY_LOCALE_PATH)) {
            this.setLocalPath(string2.getString(KEY_LOCALE_PATH));
        }
        if (string2.has(KEY_URL)) {
            this.setUrl(string2.getString(KEY_URL));
        }
        if (string2.has(KEY_TYPE)) {
            this.setType(Type.get(string2.getString(KEY_TYPE)));
        }
        if (string2.has(KEY_ATTACHMENT_STATE)) {
            this.setAttachmentState(AttachmentState.valueOf(string2.getString(KEY_ATTACHMENT_STATE)));
        }
        if (string2.has(KEY_VIDEO_ENCODED)) {
            this.setVideoEncoded(string2.getBoolean(KEY_VIDEO_ENCODED));
        }
        if (string2.has(KEY_DURATION)) {
            this.setDuration(string2.getString(KEY_DURATION));
        }
    }

    public String toString() {
        return "Name: " + this.getName() + ", Local Path: " + this.getLocalPath() + ", Type: " + (Object)((Object)this.getType()) + ", Duration: " + this.getDuration() + ", Url: " + this.getUrl() + ", Attachment State: " + (Object)((Object)this.getAttachmentState());
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Attachment) {
            return String.valueOf(((Attachment)(object = (Attachment)object)).getName()).equals(String.valueOf(this.getName())) && String.valueOf(((Attachment)object).getLocalPath()).equals(String.valueOf(this.getLocalPath())) && String.valueOf(((Attachment)object).getUrl()).equals(String.valueOf(this.getUrl())) && ((Attachment)object).getType() == this.getType() && ((Attachment)object).getAttachmentState() == this.getAttachmentState() && ((Attachment)object).isVideoEncoded() == this.isVideoEncoded() && String.valueOf(((Attachment)object).getDuration()).equals(String.valueOf(this.getDuration()));
        }
        return false;
    }

    public int hashCode() {
        if (this.getName() != null) {
            return this.getName().hashCode();
        }
        return -1;
    }

    public static enum AttachmentState {
        OFFLINE,
        SYNCED,
        NOT_AVAILABLE;

    }

    public static enum Type {
        MAIN_SCREENSHOT("main-screenshot"),
        IMAGE("image"),
        AUDIO("audio"),
        VIDEO("video"),
        ATTACHMENT_FILE("attachment-file"),
        VIEW_HIERARCHY("view-hierarchy"),
        NOT_AVAILABLE("not-available"),
        VISUAL_USER_STEPS("user-repro-steps"),
        AUTO_SCREEN_RECORDING("auto-screen-recording");

        private final String name;
        private static final Map<String, Type> lookup;

        private Type(String string3) {
            this.name = string3;
        }

        public final String toString() {
            return this.name;
        }

        public static Type get(String object) {
            if ((object = lookup.get(object)) == null) {
                return NOT_AVAILABLE;
            }
            return object;
        }

        static {
            lookup = new HashMap<String, Type>();
            for (Type type : Type.values()) {
                lookup.put(type.name, type);
            }
        }
    }
}

