/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.video.AutoScreenRecordingContract;
import com.instabug.library.internal.video.AutoScreenRecordingFileHolder;
import com.instabug.library.internal.video.AutoScreenRecordingService;
import com.instabug.library.internal.video.RequestPermissionActivity;
import com.instabug.library.model.Session;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import java.io.File;
import rx.Subscription;
import rx.functions.Action1;

public class InternalAutoScreenRecorderHelper
implements AutoScreenRecordingContract {
    private static InternalAutoScreenRecorderHelper INSTANCE;
    private AutoScreenRecordingFileHolder fileHolder = new AutoScreenRecordingFileHolder();
    private Subscription sessionSubscription;
    private Subscription activityLifeCycleSubscription;
    private boolean isCrashOccurred = false;

    public static InternalAutoScreenRecorderHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalAutoScreenRecorderHelper();
        }
        return INSTANCE;
    }

    public InternalAutoScreenRecorderHelper() {
        this.subscribeToSessionEvents();
        this.subscribeToActivityLifeCycleEvents();
    }

    @Override
    public Uri getAutoScreenRecordingFileUri() {
        return this.fileHolder.getAutoScreenRecordingFileUri();
    }

    public void setAutoScreenRecordingFile(File file) {
        this.fileHolder.setAutoScreenRecordingFile(file);
    }

    @Override
    public void delete() {
        this.fileHolder.delete();
    }

    @Override
    public void clear() {
        this.fileHolder.clear();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.getInstance().autoScreenRecordingEnabled();
    }

    public boolean isCrashOccurred() {
        return this.isCrashOccurred;
    }

    public void setCrashOccurred(boolean bl) {
        this.isCrashOccurred = bl;
    }

    private void subscribeToSessionEvents() {
        if (this.sessionSubscription == null || this.sessionSubscription.isUnsubscribed()) {
            this.sessionSubscription = SessionStateEventBus.getInstance().subscribe(new Action1<Session.SessionState>(this){
                private /* synthetic */ InternalAutoScreenRecorderHelper a;
                {
                    this.a = internalAutoScreenRecorderHelper;
                }

                public final /* synthetic */ void call(Object object) {
                    Session.SessionState sessionState = (Session.SessionState)((Object)object);
                    object = this;
                    if (sessionState == Session.SessionState.FINISH && !object.a.isCrashOccurred()) {
                        AutoScreenRecordingEventBus.getInstance().post(AutoScreenRecordingService.Action.STOP_DELETE);
                        SettingsManager.getInstance().setAutoScreenRecordingDenied(false);
                        object.a.unsubscribeFromSessionEvents();
                    }
                }
            });
        }
    }

    private void subscribeToActivityLifeCycleEvents() {
        if (this.activityLifeCycleSubscription == null || this.activityLifeCycleSubscription.isUnsubscribed()) {
            this.activityLifeCycleSubscription = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Action1<ActivityLifeCycleEvent>(this){
                private /* synthetic */ InternalAutoScreenRecorderHelper a;
                {
                    this.a = internalAutoScreenRecorderHelper;
                }

                public final /* synthetic */ void call(Object object) {
                    ActivityLifeCycleEvent activityLifeCycleEvent = (ActivityLifeCycleEvent)((Object)object);
                    object = this;
                    switch (activityLifeCycleEvent) {
                        case RESUMED: {
                            object.a.subscribeToSessionEvents();
                            activityLifeCycleEvent = new Handler();
                            activityLifeCycleEvent.postDelayed(new Runnable(object){

                                @Override
                                public final void run() {
                                    InternalAutoScreenRecorderHelper.getInstance().start();
                                }
                            }, 500L);
                        }
                    }
                }
            });
        }
    }

    private void unsubscribeFromSessionEvents() {
        if (!this.sessionSubscription.isUnsubscribed()) {
            this.sessionSubscription.unsubscribe();
        }
    }

    public void start() {
        if (SettingsManager.getInstance().isScreenCurrentlyRecorded() || SettingsManager.getInstance().isAutoScreenRecordingDenied() || !this.isEnabled()) {
            return;
        }
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity != null && !(activity instanceof _InstabugActivity) && SettingsManager.getInstance().isAppOnForeground() && Instabug.getState() == InstabugState.ENABLED && !InstabugCore.isForegroundBusy()) {
            Intent intent = new Intent((Context)activity, RequestPermissionActivity.class);
            activity.startActivity(intent);
            activity.overridePendingTransition(0, 0);
        }
    }
}

