/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.Session;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class SessionsCacheManager {
    public static final String SESSIONS_DISK_CACHE_FILE_NAME = "/sessions.cache";
    public static final String SESSIONS_DISK_CACHE_KEY = "sessions_disk_cache";
    public static final String SESSIONS_MEMORY_CACHE_KEY = "sessions_memory_cache";

    @Nullable
    public static InMemoryCache<Long, Session> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(SESSIONS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(SessionsCacheManager.class, "In-memory Sessions cache not found, loading it from disk " + CacheManager.getInstance().getCache(SESSIONS_MEMORY_CACHE_KEY));
            CacheManager.getInstance().migrateCache(SESSIONS_DISK_CACHE_KEY, SESSIONS_MEMORY_CACHE_KEY, new CacheManager.KeyExtractor<Long, Session>(){

                @Override
                public final /* synthetic */ Object extractKey(Object object) {
                    object = (Session)object;
                    return ((Session)object).b();
                }
            });
            Cache cache = CacheManager.getInstance().getCache(SESSIONS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(SessionsCacheManager.class, "In-memory Sessions cache restored from disk, " + cache.getValues().size() + " elements restored");
            }
        }
        InstabugSDKLogger.d(SessionsCacheManager.class, "In-memory Sessions cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(SESSIONS_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() {
        Object object = CacheManager.getInstance().getCache(SESSIONS_MEMORY_CACHE_KEY);
        Cache cache = CacheManager.getInstance().getCache(SESSIONS_DISK_CACHE_KEY);
        if (object != null && cache != null) {
            object = new Thread(new Runnable((Cache)object, cache){
                private /* synthetic */ Cache a;
                private /* synthetic */ Cache b;
                {
                    this.a = cache;
                    this.b = cache2;
                }

                @Override
                public final void run() {
                    CacheManager.getInstance().migrateCache(this.a, this.b, new CacheManager.KeyExtractor<String, Session>(this){

                        @Override
                        public final /* synthetic */ Object extractKey(Object object) {
                            object = (Session)object;
                            return String.valueOf(((Session)object).b());
                        }
                    });
                }
            });
            ((Thread)object).start();
        }
    }

    public static void addSession(Session session) {
        InMemoryCache<Long, Session> inMemoryCache = SessionsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put(session.b(), session);
        }
    }

    @Nullable
    public static Session getSession(long l) {
        InMemoryCache<Long, Session> inMemoryCache = SessionsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.get(l);
        }
        return null;
    }

    @Nullable
    public static Session deleteSession(Session session) {
        InMemoryCache<Long, Session> inMemoryCache = SessionsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.delete(session.b());
        }
        return null;
    }

    public static List<Session> getSessions() {
        InMemoryCache<Long, Session> inMemoryCache = SessionsCacheManager.getCache();
        if (inMemoryCache != null) {
            return inMemoryCache.getValues();
        }
        return new ArrayList<Session>();
    }
}

