/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheChangedListener;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import java.util.List;

public class CacheManager {
    public static final String DEFAULT_IN_MEMORY_CACHE_KEY = "DEFAULT_IN_MEMORY_CACHE_KEY";
    private final List<Cache> caches = new ArrayList<Cache>();
    private static CacheManager INSTANCE;

    public CacheManager() {
        InMemoryCache inMemoryCache = new InMemoryCache(DEFAULT_IN_MEMORY_CACHE_KEY);
        this.caches.add(inMemoryCache);
    }

    public static synchronized CacheManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CacheManager();
        }
        return INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public Cache getCache(String string2) {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                if (!cache.getId().equals(string2)) continue;
                return cache;
            }
        }
        InstabugSDKLogger.d(this, "No cache with this ID was found " + string2 + " returning null");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache addCache(Cache cache) {
        Object object = this.getCache(cache.getId());
        if (object != null) {
            return object;
        }
        object = this.caches;
        synchronized (object) {
            this.caches.add(cache);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteCache(String object) {
        Cache cache = this.getCache((String)object);
        if (cache != null) {
            object = this.caches;
            synchronized (object) {
                return this.caches.remove(cache);
            }
        }
        InstabugSDKLogger.d(this, "No cache was this ID was found " + (String)object + " to be deleted");
        return false;
    }

    public boolean cacheExists(String string2) {
        return this.getCache(string2) != null;
    }

    public boolean subscribe(String object, CacheChangedListener cacheChangedListener) {
        if (this.cacheExists((String)object)) {
            object = this.getCache((String)object);
            return ((Cache)object).addOnCacheChangedListener(cacheChangedListener);
        }
        throw new IllegalArgumentException("No cache exists with this ID to subscribe to");
    }

    public boolean unSubscribe(String object, CacheChangedListener cacheChangedListener) {
        if (this.cacheExists((String)object)) {
            object = this.getCache((String)object);
            return ((Cache)object).removeOnCacheChangedListener(cacheChangedListener);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCaches() {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                cache.invalidate();
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAllCachesButUserAttributes() {
        List<Cache> list = this.caches;
        synchronized (list) {
            for (Cache cache : this.caches) {
                if (cache.getId().equalsIgnoreCase("attrs") || cache.getId().equalsIgnoreCase("/user_attributes.cache") || cache.getId().equalsIgnoreCase("user_attributes_disk_cache") || cache.getId().equalsIgnoreCase("user_attributes_memory_cache")) continue;
                cache.invalidate();
            }
        }
        InstabugSDKLogger.d(this, "All caches have been invalidated");
    }

    public <K, V> void migrateCache(@NonNull String object, @NonNull String string2, KeyExtractor<K, V> keyExtractor) throws IllegalArgumentException {
        object = this.getCache((String)object);
        InMemoryCache inMemoryCache = this.getCache(string2);
        InstabugSDKLogger.v(this, "Caches to be migrated " + object + " - " + inMemoryCache);
        if (object == null) {
            InstabugSDKLogger.e(this, "Migration exception ", new IllegalArgumentException("No cache with these keys was found to migrate from"));
            return;
        }
        if (inMemoryCache == null) {
            inMemoryCache = new InMemoryCache(string2);
            this.addCache(inMemoryCache);
        }
        this.migrateCache((Cache<K, V>)object, inMemoryCache, keyExtractor);
    }

    public <K, V> void migrateCache(@NonNull Cache<K, V> iterator, @NonNull Cache<K, V> cache, KeyExtractor<K, V> keyExtractor) {
        InstabugSDKLogger.d(this, "Invalidated migratingTo cache");
        if (cache == null || iterator == null) {
            InstabugSDKLogger.w(CacheManager.class, "cache migration process got failure, migratingToCache: " + cache + ", migratingFromCache: " + iterator);
            return;
        }
        cache.invalidate();
        iterator = ((Cache)((Object)iterator)).getValues();
        if (iterator == null || iterator.isEmpty()) {
            InstabugSDKLogger.w(this, "Cache to migrate from doesn't contain any elements, not going further with the migration");
            return;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Object e2 = iterator.next();
            if (e2 == null) continue;
            InstabugSDKLogger.v(this, "Adding value " + e2 + " with key " + keyExtractor.extractKey(e2));
            cache.put(keyExtractor.extractKey(e2), e2);
        }
    }

    public static abstract class KeyExtractor<K, V> {
        public abstract K extractKey(V var1);
    }
}

