/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.os.Environment;
import com.instabug.library.internal.storage.cache.AssetCache;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.network.Request;
import com.instabug.library.network.a.b;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import rx.Subscription;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static LinkedHashMap<String, a> currentDownloadingFiles = new LinkedHashMap();

    public static AssetCache getCache() {
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache not found, create it");
            CacheManager.getInstance().addCache(new AssetCache(ASSETS_MEMORY_CACHE_KEY));
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets created successfully");
        }
        InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache found");
        return (AssetCache)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    public static AssetEntity createEmptyEntity(Context object, String string2, AssetEntity.AssetType assetType) {
        object = new File(AssetsCacheManager.getCashDirectory(object), String.valueOf(string2.hashCode()));
        return new AssetEntity(String.valueOf(string2.hashCode()), assetType, string2, (File)object);
    }

    public static void getAssetEntity(Context context, AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        Object object = AssetsCacheManager.getCache();
        object = object != null ? (AssetEntity)((InMemoryCache)object).get(assetEntity.getKey()) : null;
        if (object != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Get file from cache");
            onDownloadFinished.onSuccess((AssetEntity)object);
            return;
        }
        if (AssetsCacheManager.isDownloading(assetEntity.getKey())) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File currently downloading, wait download to finish");
            AssetsCacheManager.waitDownloadToFinish(assetEntity, onDownloadFinished);
            return;
        }
        InstabugSDKLogger.d(AssetsCacheManager.class, "File not exist download it");
        AssetsCacheManager.downloadAssetEntity(context, assetEntity, onDownloadFinished);
    }

    public static void downloadAssetEntity(Context context, AssetEntity assetEntity, OnDownloadFinished object) {
        a a2 = new a();
        AssetEntity assetEntity2 = assetEntity;
        Object object2 = a2;
        a2.a = assetEntity2;
        object2 = a2;
        object2 = ((a)object2).c;
        object2.add((OnDownloadFinished)object);
        object = object2;
        object2 = a2;
        a2.c = object;
        context = b.a().a(context, assetEntity, new Request.Callbacks<AssetEntity, Throwable>(assetEntity){
            private /* synthetic */ AssetEntity a;
            {
                this.a = assetEntity;
            }

            @Override
            public final /* synthetic */ void onFailed(Object object) {
                Throwable throwable = (Throwable)object;
                object = this;
                InstabugSDKLogger.e(object, "downloading asset entity got error: ", throwable);
                AssetsCacheManager.notifyDownloadFailed(object.a, throwable);
            }

            @Override
            public final /* synthetic */ void onSucceeded(Object object) {
                object = (AssetEntity)object;
                AssetsCacheManager.addAssetEntity((AssetEntity)object);
                AssetsCacheManager.notifyDownloadFinishedSuccessfully((AssetEntity)object);
            }
        });
        assetEntity2 = context;
        object2 = a2;
        a2.b = assetEntity2;
        object2 = a2;
        currentDownloadingFiles.put(((a)object2).a.getKey(), a2);
    }

    public static void addAssetEntity(AssetEntity assetEntity) {
        AssetCache assetCache = AssetsCacheManager.getCache();
        if (assetCache != null) {
            assetCache.put(assetEntity.getKey(), assetEntity);
        }
    }

    public static boolean isDownloading(String string2) {
        return currentDownloadingFiles.get(string2) != null;
    }

    public static void waitDownloadToFinish(AssetEntity object, OnDownloadFinished onDownloadFinished) {
        Object object2 = currentDownloadingFiles.get(((AssetEntity)object).getKey());
        object2 = ((a)object2).c;
        object2.add((OnDownloadFinished)onDownloadFinished);
        a a2 = currentDownloadingFiles.get(((AssetEntity)object).getKey());
        object = object2;
        object2 = a2;
        a2.c = object;
    }

    public static void notifyDownloadFinishedSuccessfully(AssetEntity assetEntity) {
        a a2 = currentDownloadingFiles.get(assetEntity.getKey());
        for (OnDownloadFinished onDownloadFinished : a2.c) {
            if (onDownloadFinished == null) continue;
            onDownloadFinished.onSuccess(assetEntity);
            currentDownloadingFiles.remove(assetEntity.getKey());
        }
    }

    public static void notifyDownloadFailed(AssetEntity assetEntity, Throwable throwable) {
        a a2 = currentDownloadingFiles.get(assetEntity.getKey());
        for (OnDownloadFinished onDownloadFinished : a2.c) {
            if (onDownloadFinished == null) continue;
            onDownloadFinished.onFailed(throwable);
            currentDownloadingFiles.remove(assetEntity.getKey());
        }
    }

    public static void stopRunningDownloads() {
        for (Map.Entry<String, a> entry : currentDownloadingFiles.entrySet()) {
            a object = entry.getValue();
            object.b.unsubscribe();
        }
        currentDownloadingFiles.clear();
    }

    public static void clearRedundantFiles(Context fileArray) {
        if ((fileArray = AssetsCacheManager.getCashDirectory((Context)fileArray).listFiles()) == null) {
            return;
        }
        for (File file : fileArray) {
            file.delete();
        }
    }

    public static void cleanUpCache(Context context) {
        Cache cache;
        AssetsCacheManager.stopRunningDownloads();
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY) && (cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY)) != null) {
            cache.invalidate();
        }
        AssetsCacheManager.clearRedundantFiles(context);
    }

    public static File getCashDirectory(Context object) {
        if (Environment.getExternalStorageState().equals("mounted") && object.getExternalCacheDir() != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Media Mounted");
            object = object.getExternalCacheDir().getPath();
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "External storage not available, saving file to internal storage.");
            object = object.getCacheDir().getAbsolutePath();
        }
        object = new File((String)object + "/instabug/assetCache");
        if (!((File)object).exists()) {
            boolean bl = ((File)object).mkdirs();
            InstabugSDKLogger.d(AssetsCacheManager.class, "Is created: " + bl);
            Serializable serializable = new File((File)object, ".nomedia");
            try {
                serializable.createNewFile();
            }
            catch (IOException iOException) {
                serializable = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
    }

    public static interface OnDownloadFinished {
        public void onSuccess(AssetEntity var1);

        public void onFailed(Throwable var1);
    }

    public static final class a {
        public AssetEntity a;
        public Subscription b;
        public List<OnDownloadFinished> c = new ArrayList<OnDownloadFinished>();
    }
}

