/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import com.instabug.library.internal.storage.AttachmentsUtility;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class DiskUtils {
    public static File getInstabugDirectory(@NonNull Context object) {
        Object object2;
        block6: {
            if (object.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
                try {
                    object2 = object.getExternalFilesDir(null).getAbsolutePath();
                    break block6;
                }
                catch (NullPointerException nullPointerException) {}
            }
            object2 = DiskUtils.getInternalStoragePath((Context)object);
            InstabugSDKLogger.i(AttachmentsUtility.class, "External storage not available, saving file to internal storage.");
        }
        object = new File((String)object2 + "/instabug/");
        if (!((File)object).exists() && ((File)object).mkdirs()) {
            object2 = new File((File)object, ".nomedia");
            try {
                ((File)object2).createNewFile();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
    }

    private static String getInternalStoragePath(Context context) {
        return context.getFilesDir().getAbsolutePath();
    }

    public static void saveBitmapOnDisk(Bitmap bitmap, File file) throws IOException {
        if (bitmap != null && file != null) {
            InstabugSDKLogger.v(DiskUtils.class, "starting save viewHierarchy image, path: " + file.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)fileOutputStream);
            fileOutputStream.close();
            InstabugSDKLogger.v(DiskUtils.class, "viewHierarchy image saved, path: " + file.getAbsolutePath() + ", time in MS: " + System.currentTimeMillis());
        }
    }

    public static void cleanDirectory(File fileArray) {
        if (fileArray.exists() && fileArray.isDirectory() && (fileArray = fileArray.listFiles()) != null) {
            for (File file : fileArray) {
                if (!file.delete()) continue;
                InstabugSDKLogger.v(DiskUtils.class, "file deleted successfully, path: " + file.getPath() + ", time in MS: " + System.currentTimeMillis());
            }
        }
    }

    public static void copyFromUriIntoFile(Context object, Uri object2, File object3) throws IOException {
        int n;
        object2 = new BufferedInputStream(object.getContentResolver().openInputStream((Uri)object2));
        InstabugSDKLogger.d(AttachmentsUtility.class, "Target file path: " + ((File)object3).getPath());
        object = new BufferedOutputStream(object.getContentResolver().openOutputStream(Uri.fromFile((File)object3)));
        object3 = new byte[32768];
        while ((n = ((FilterInputStream)object2).read((byte[])object3)) > 0) {
            ((BufferedOutputStream)object).write((byte[])object3, 0, n);
        }
        ((FilterOutputStream)object).close();
        ((BufferedInputStream)object2).close();
    }

    public static void deleteFile(String object) {
        object = new File((String)object);
        ((File)object).delete();
    }
}

