/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.Context;
import android.net.Uri;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.DiskUtils;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class AttachmentsUtility {
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    public static File getVideoFile(Context object) {
        object = AttachmentsUtility.getNewDirectory(object, "videos");
        Object object2 = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object2 = "video-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    public static File getFilesAttachmentDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "attachments");
    }

    public static File getNewDirectory(Context object, String object2) {
        if (!((File)(object = new File(DiskUtils.getInstabugDirectory((Context)object) + "/" + (String)object2 + "/"))).exists() && ((File)object).mkdirs()) {
            object2 = new File((File)object, ".nomedia");
            try {
                ((File)object2).createNewFile();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
    }

    public static File getVideoRecordingFramesDirectory(Context context) {
        return AttachmentsUtility.getNewDirectory(context, "frames");
    }

    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        if ((activity = activity.managedQuery(uri, stringArray, null, null, null)) != null) {
            int n = activity.getColumnIndexOrThrow("_data");
            activity.moveToFirst();
            return activity.getString(n);
        }
        return null;
    }

    @Nullable
    public static Uri getNewFileAttachmentUri(Context context, Uri uri, String object) {
        if (uri == null) {
            return null;
        }
        String string2 = uri.getLastPathSegment().toLowerCase();
        File file = AttachmentsUtility.getFilesAttachmentDirectory(context);
        if (object != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri)) {
            string2 = object;
        }
        if (((File)(object = new File(file, string2))).exists()) {
            object = new File(file, String.valueOf(System.currentTimeMillis()) + "_" + string2);
        }
        try {
            DiskUtils.copyFromUriIntoFile(context, uri, (File)object);
            if (!AttachmentsUtility.validateFileSize((File)object, 50.0)) {
                InstabugSDKLogger.i(AttachmentsUtility.class, "Attachment file size exceeds than the limit 50.0");
                return null;
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentsUtility.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    public static Uri getNewFileAttachmentUri(Context context, Uri uri) {
        return AttachmentsUtility.getNewFileAttachmentUri(context, uri, null);
    }

    public static File getAttachmentFile(Context object, String string2) {
        File file = new File((File)(object = AttachmentsUtility.getFilesAttachmentDirectory(object)), string2);
        if (file.exists()) {
            file = new File((File)object, String.valueOf(System.currentTimeMillis()) + "_" + string2);
        }
        return file;
    }

    public static Uri getUriFromBytes(Context object, byte[] byArray, String string2) {
        object = AttachmentsUtility.getAttachmentFile(object, string2);
        try {
            AttachmentsUtility.saveBytesToFile(byArray, (File)object);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentsUtility.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    private static void saveBytesToFile(byte[] byArray, File object) throws IOException {
        object = new BufferedOutputStream(new FileOutputStream((File)object));
        ((FilterOutputStream)object).write(byArray);
        ((BufferedOutputStream)object).flush();
        ((FilterOutputStream)object).close();
    }

    private static boolean validateFileSize(File file, double d2) {
        long l = file.length();
        double d3 = (double)l / 1048576.0;
        InstabugSDKLogger.d(AttachmentsUtility.class, "External attachment file size is " + l + " bytes or " + d3 + " MBs");
        return !(d3 > d2);
    }
}

