/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Environment;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.broadcast.LastContactedChangedBroadcast;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AttachmentManager {
    private static final double MAX_FILE_SIZE_IN_MB = 50.0;

    public static File getAttachmentDirectory(@NonNull Context object) {
        Object object2;
        if (object.getExternalFilesDir(null) != null && Environment.getExternalStorageState().equals("mounted")) {
            try {
                object2 = object.getExternalFilesDir(null).getAbsolutePath();
            }
            catch (NullPointerException nullPointerException) {}
        }
        object2 = AttachmentManager.getInternalStoragePath((Context)object);
        object = new File((String)object2 + "/instabug/");
        if (!((File)object).exists()) {
            ((File)object).mkdirs();
            object2 = new File((File)object, ".nomedia");
            try {
                ((File)object2).createNewFile();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
    }

    public static File getNewDirectory(Context object, String object2) {
        if (!((File)(object = new File(AttachmentManager.getAttachmentDirectory((Context)object) + "/" + (String)object2 + "/"))).exists()) {
            ((File)object).mkdirs();
            object2 = new File((File)object, ".nomedia");
            try {
                ((File)object2).createNewFile();
            }
            catch (IOException iOException) {
                object2 = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
    }

    public static File getVideoFile(Context object) {
        object = AttachmentManager.getVideoRecordingVideosDirectory(object);
        Object object2 = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.getDefault());
        object2 = "video-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    public static File getVideoRecordingFramesDirectory(Context object) {
        if (!((File)(object = new File(AttachmentManager.getAttachmentDirectory((Context)object) + "/frames/"))).exists()) {
            ((File)object).mkdirs();
            Serializable serializable = new File((File)object, ".nomedia");
            try {
                serializable.createNewFile();
            }
            catch (IOException iOException) {
                serializable = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
    }

    public static File getVideoRecordingVideosDirectory(Context object) {
        if (!((File)(object = new File(AttachmentManager.getAttachmentDirectory((Context)object) + "/videos/"))).exists()) {
            ((File)object).mkdirs();
            Serializable serializable = new File((File)object, ".nomedia");
            try {
                serializable.createNewFile();
            }
            catch (IOException iOException) {
                serializable = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
    }

    public static File getAutoScreenRecordingVideosDirectory(Context object) {
        if (!((File)(object = new File(AttachmentManager.getAttachmentDirectory((Context)object) + "/auto_recording/"))).exists()) {
            ((File)object).mkdirs();
            Serializable serializable = new File((File)object, ".nomedia");
            try {
                serializable.createNewFile();
            }
            catch (IOException iOException) {
                serializable = iOException;
                iOException.printStackTrace();
            }
        }
        return object;
    }

    public static File getAutoScreenRecordingFile(Context object) {
        object = AttachmentManager.getAutoScreenRecordingVideosDirectory(object);
        Object object2 = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss.SSS", Locale.ENGLISH);
        object2 = "auto-recording-" + ((DateFormat)object2).format(new Date()) + ".mp4";
        return new File((File)object, (String)object2);
    }

    private static String getInternalStoragePath(Context context) {
        InstabugSDKLogger.i(AttachmentManager.class, "External storage not available, saving file to internal storage.");
        return context.getFilesDir().getAbsolutePath();
    }

    private static void saveBytesToFile(byte[] byArray, File object) throws IOException {
        object = new BufferedOutputStream(new FileOutputStream((File)object));
        ((FilterOutputStream)object).write(byArray);
        ((BufferedOutputStream)object).flush();
        ((FilterOutputStream)object).close();
    }

    private static File getAttachmentFile(Context object, String string2) {
        File file = new File((File)(object = AttachmentManager.getAttachmentDirectory(object)), string2);
        if (file.exists()) {
            file = new File((File)object, String.valueOf(System.currentTimeMillis()) + "_" + string2);
        }
        return file;
    }

    public static Uri getUriFromBytes(Context object, byte[] byArray, String string2) {
        object = AttachmentManager.getAttachmentFile(object, string2);
        try {
            AttachmentManager.saveBytesToFile(byArray, (File)object);
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentManager.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    public static void copyFromUriIntoFile(Context object, Uri object2, File object3) throws IOException {
        int n;
        object2 = new BufferedInputStream(object.getContentResolver().openInputStream((Uri)object2));
        InstabugSDKLogger.d(AttachmentManager.class, "Target file path: " + ((File)object3).getPath());
        object = new BufferedOutputStream(object.getContentResolver().openOutputStream(Uri.fromFile((File)object3)));
        object3 = new byte[32768];
        while ((n = ((FilterInputStream)object2).read((byte[])object3)) > 0) {
            ((BufferedOutputStream)object).write((byte[])object3, 0, n);
        }
        ((FilterOutputStream)object).close();
        ((BufferedInputStream)object2).close();
    }

    @Nullable
    public static String getGalleryImagePath(Activity activity, Uri uri) {
        String[] stringArray = new String[]{"_data"};
        if ((activity = activity.managedQuery(uri, stringArray, null, null, null)) != null) {
            int n = activity.getColumnIndexOrThrow("_data");
            activity.moveToFirst();
            return activity.getString(n);
        }
        return null;
    }

    @Nullable
    public static Uri getNewFileUri(Context context, Uri uri, String object) {
        if (uri == null) {
            return null;
        }
        Object object2 = uri.getLastPathSegment().toLowerCase();
        if (object != null && SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri)) {
            object2 = object;
        }
        object = AttachmentManager.getAttachmentFile(context, (String)object2);
        try {
            AttachmentManager.copyFromUriIntoFile(context, uri, (File)object);
            if (!AttachmentManager.validateFileSize(uri, (File)object)) {
                return null;
            }
        }
        catch (IOException iOException) {
            InstabugSDKLogger.e(AttachmentManager.class, iOException.getMessage(), iOException);
            return null;
        }
        return Uri.fromFile((File)object);
    }

    public static Uri getNewFileUri(Context context, Uri uri) {
        return AttachmentManager.getNewFileUri(context, uri, null);
    }

    private static boolean validateFileSize(Uri uri, File file) {
        if (SettingsManager.getInstance().getExtraAttachmentFiles().containsKey(uri)) {
            long l = file.length();
            double d2 = (double)l / 1048576.0;
            InstabugSDKLogger.d(AttachmentManager.class, "External attachment file size is " + l + " bytes or " + d2 + " MBs");
            if (d2 > 50.0) {
                InstabugSDKLogger.i(AttachmentManager.class, "Attachment exceeds 50.0 MBs file size limit, ignoring attachment");
                return false;
            }
        }
        return true;
    }

    public static void saveBitmap$3b0ced6(Bitmap bitmap, Context object, LastContactedChangedBroadcast.a object2) {
        object = AttachmentManager.getAttachmentDirectory((Context)object);
        object = new File((File)object, "bug_" + System.currentTimeMillis() + "_.jpg");
        InstabugSDKLogger.v(AttachmentManager.class, "image path: " + ((File)object).toString());
        try {
            object2 = new BufferedOutputStream(new FileOutputStream((File)object));
            bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)object2);
            ((FilterOutputStream)object2).close();
            bitmap = Uri.fromFile((File)object);
            if (bitmap == null) {
                new Throwable("Uri equal null");
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public static void saveBitmap$6eeaf3eb(Bitmap bitmap, File file, LastContactedChangedBroadcast.a object) {
        file = new File(file, "frame_" + System.currentTimeMillis() + "_.jpg");
        InstabugSDKLogger.v(AttachmentManager.class, "video frame path: " + file.toString());
        try {
            object = new BufferedOutputStream(new FileOutputStream(file));
            int n = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getWidth() : bitmap.getHeight();
            if (n > 640) {
                bitmap = AttachmentManager.resizeBitmap(bitmap, 640);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)object);
            } else {
                bitmap = AttachmentManager.resizeBitmap(bitmap, 320);
                bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)object);
            }
            ((FilterOutputStream)object).close();
            bitmap = Uri.fromFile((File)file);
            if (bitmap == null) {
                new Throwable("Uri equal null");
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    private static Bitmap resizeBitmap(Bitmap bitmap, int n) {
        float f2;
        int n2 = bitmap.getWidth();
        int n3 = bitmap.getHeight();
        float f3 = (float)n2 / (float)n3;
        if (f2 > 1.0f) {
            n2 = n;
            n3 = (int)((float)n / f3);
        } else {
            n3 = n;
            n2 = (int)((float)n * f3);
        }
        return Bitmap.createScaledBitmap((Bitmap)bitmap, (int)n2, (int)n3, (boolean)false);
    }
}

