/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.device;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.media.AudioManager;
import android.os.Build;
import android.text.TextUtils;
import com.instabug.library.util.InstabugSDKLogger;

public class InstabugDeviceProperties {
    public static String getAppVersion(Context object) {
        PackageInfo packageInfo = new PackageInfo();
        try {
            packageInfo = object.getPackageManager().getPackageInfo(object.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e(InstabugDeviceProperties.class, "failed to get app version", nameNotFoundException);
        }
        object = String.format("%s (%s)", packageInfo.versionName, packageInfo.versionCode);
        return object;
    }

    public static String getAppVersionName(Context object) {
        PackageInfo packageInfo = new PackageInfo();
        try {
            packageInfo = object.getPackageManager().getPackageInfo(object.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e(InstabugDeviceProperties.class, "failed to get app version", nameNotFoundException);
        }
        object = packageInfo.versionName;
        return object;
    }

    public static String getPackageName(Context object) {
        try {
            object = object.getApplicationInfo().packageName;
        }
        catch (Exception exception) {
            object = "Could not get information";
            InstabugSDKLogger.e(InstabugDeviceProperties.class, "failed to get package name", exception);
        }
        return object;
    }

    public static boolean isStoreVersion(Context object) {
        try {
            object = object.getPackageManager().getInstallerPackageName(object.getPackageName());
            return !TextUtils.isEmpty((CharSequence)object);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(InstabugDeviceProperties.class, "failed to get installer package name", exception);
            return false;
        }
    }

    public static String getDeviceType() {
        return Build.MANUFACTURER + " " + Build.MODEL;
    }

    public static int getCurrentOSLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }

    public static boolean checkRingerIsOn(Context context) {
        if ((context = (AudioManager)context.getSystemService("audio")) != null) {
            return context.getRingerMode() == 2;
        }
        return true;
    }
}

