/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics.model;

import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SDKEvent {
    private static final String KEY_TIME_STAMP = "time_stamp";
    private static final String KEY_EVENT_NAME = "event_name";
    private static final String KEY_EXTRA_ATTRIBUTES = "extra_attributes";
    private long timeStamp;
    private String eventName;
    private ArrayList<ExtraAttribute> extraAttributes;

    public String getEventName() {
        return this.eventName;
    }

    public SDKEvent setEventName(String string2) {
        this.eventName = string2;
        return this;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public SDKEvent setTimeStamp(long l) {
        this.timeStamp = l;
        return this;
    }

    public ArrayList<ExtraAttribute> getExtraAttributes() {
        return this.extraAttributes;
    }

    public SDKEvent setExtraAttributes(ArrayList<ExtraAttribute> arrayList) {
        this.extraAttributes = arrayList;
        return this;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_TIME_STAMP, this.getTimeStamp()).put(KEY_EVENT_NAME, (Object)this.getEventName()).put(KEY_EXTRA_ATTRIBUTES, (Object)ExtraAttribute.toJson(this.getExtraAttributes()));
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(SDKEvent.class, jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public static JSONArray toJson(ArrayList<SDKEvent> object) {
        JSONArray jSONArray = new JSONArray();
        object = ((ArrayList)object).iterator();
        while (object.hasNext()) {
            SDKEvent sDKEvent = (SDKEvent)object.next();
            jSONArray.put((Object)sDKEvent.toJson());
        }
        return jSONArray;
    }

    public static class ExtraAttribute {
        private static final String KEY_KEY = "key";
        private static final String KEY_VALUE = "value";
        private String key;
        private String value;

        public String getKey() {
            return this.key;
        }

        public ExtraAttribute setKey(String string2) {
            this.key = string2;
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public ExtraAttribute setValue(String string2) {
            this.value = string2;
            return this;
        }

        public JSONObject toJson() {
            JSONObject jSONObject = new JSONObject();
            try {
                jSONObject.put(KEY_KEY, (Object)this.getKey()).put(KEY_VALUE, (Object)this.getValue());
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(SDKEvent.class, jSONException.getMessage(), jSONException);
            }
            return jSONObject;
        }

        public static ExtraAttribute fromJson(JSONObject jSONObject) {
            ExtraAttribute extraAttribute = new ExtraAttribute();
            try {
                if (jSONObject.has(KEY_KEY)) {
                    extraAttribute.setKey(jSONObject.getString(KEY_KEY));
                }
                if (jSONObject.has(KEY_VALUE)) {
                    extraAttribute.setValue(jSONObject.getString(KEY_VALUE));
                }
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(SDKEvent.class, jSONException.getMessage(), jSONException);
            }
            return extraAttribute;
        }

        public static JSONArray toJson(ArrayList<ExtraAttribute> object) {
            JSONArray jSONArray = new JSONArray();
            object = ((ArrayList)object).iterator();
            while (object.hasNext()) {
                ExtraAttribute extraAttribute = (ExtraAttribute)object.next();
                jSONArray.put((Object)extraAttribute.toJson());
            }
            return jSONArray;
        }

        public static ArrayList<ExtraAttribute> fromJson(JSONArray jSONArray) {
            ArrayList<ExtraAttribute> arrayList = new ArrayList<ExtraAttribute>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    arrayList.add(ExtraAttribute.fromJson(jSONArray.getJSONObject(i)));
                    continue;
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e(SDKEvent.class, jSONException.getMessage(), jSONException);
                }
            }
            return arrayList;
        }
    }
}

