/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.app.Activity;
import android.os.Bundle;
import android.support.annotation.LayoutRes;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.instabug.library.R;
import com.instabug.library.util.InstabugSDKLogger;

public abstract class InstabugBaseFragment
extends Fragment {
    private View view;
    private Activity activity;
    private boolean isStateRestored;

    @LayoutRes
    protected abstract int getLayout();

    protected abstract String getTitle();

    protected abstract void consumeNewInstanceSavedArguments();

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        this.activity = activity;
    }

    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        InstabugSDKLogger.v((Object)this, "onCreateView called");
        if (this.getArguments() != null) {
            InstabugSDKLogger.v((Object)this, "Arguments found, calling consumeNewInstanceSavedArguments with " + this.getArguments());
            this.consumeNewInstanceSavedArguments();
        }
        this.isStateRestored = false;
    }

    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        InstabugSDKLogger.v((Object)this, "onCreateView called");
        this.view = layoutInflater.inflate(this.getLayout(), viewGroup, false);
        this.setTitle(this.getTitle());
        return this.view;
    }

    protected abstract void restoreState(Bundle var1);

    public void onViewCreated(View view, Bundle bundle) {
        InstabugSDKLogger.v((Object)this, "onViewCreated called");
        super.onViewCreated(view, bundle);
        if (bundle != null) {
            InstabugSDKLogger.v((Object)this, "savedInstanceState found, calling restoreState");
            this.restoreState(bundle);
            this.isStateRestored = true;
        }
    }

    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        InstabugSDKLogger.v((Object)this, "onSaveInstanceState called, calling saveState");
        this.saveState(bundle);
    }

    public void onPause() {
        super.onPause();
        InstabugSDKLogger.v((Object)this, "onPause called, calling saveState");
    }

    public void onResume() {
        super.onResume();
        InstabugSDKLogger.v((Object)this, "onResume called, calling saveState");
    }

    protected abstract void saveState(Bundle var1);

    public boolean isStateRestored() {
        return this.isStateRestored;
    }

    public Activity getPreservedActivity() {
        InstabugSDKLogger.v((Object)this, "Returning preserved activity " + this.activity);
        return this.activity;
    }

    public void setTitle(String string2) {
        if (this.view == null) {
            InstabugSDKLogger.v((Object)this, "Calling setTitle before inflating the view! Ignoring call");
            return;
        }
        TextView textView = (TextView)this.view.findViewById(R.id.instabug_fragment_title);
        if (textView != null) {
            InstabugSDKLogger.v((Object)this, "Setting fragment title to \"" + string2 + "\"");
            textView.setText((CharSequence)string2);
            return;
        }
        InstabugSDKLogger.v((Object)this, "instabug_fragment_title wasn't found, make sure your layout.xml contains it");
    }
}

