/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library;

import android.content.Context;
import android.graphics.ColorFilter;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugCustomTextPlaceHolder;
import com.instabug.library.R;
import com.instabug.library.internal.media.AudioPlayer;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.util.Colorizer;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.PermissionsUtils;
import com.instabug.library.util.PlaceHolderUtils;
import java.util.Timer;
import java.util.TimerTask;

public class InstabugAudioRecordingFragment
extends Fragment
implements View.OnClickListener,
View.OnTouchListener {
    private static final String EXTRA_FILE_PATH = "com.instabug.library.audio_attachment_path";
    private ImageView mRecordButtonBackground;
    private boolean mIsRecordingActive = false;
    private ImageView mRecordButtonIcon;
    private PorterDuffColorFilter mColorFilter;
    private Timer mRecordingTimer;
    private com.instabug.library.internal.media.a mRecorder;
    private int mCurrentTime;
    private TimerTask mTimerTask = new a();
    private TextView timerTextView;
    private TextView titleTextView;
    private boolean mIsRecordingPermissionGranted;
    private boolean isFirstPermissionRequested = false;
    private Callbacks listener;

    public static InstabugAudioRecordingFragment newInstance(String string2) {
        InstabugAudioRecordingFragment instabugAudioRecordingFragment = new InstabugAudioRecordingFragment();
        Bundle bundle = new Bundle();
        bundle.putString(EXTRA_FILE_PATH, string2);
        instabugAudioRecordingFragment.setArguments(bundle);
        return instabugAudioRecordingFragment;
    }

    public static InstabugAudioRecordingFragment newInstance(String object, Callbacks callbacks) {
        object = InstabugAudioRecordingFragment.newInstance(object);
        v0.listener = callbacks;
        return object;
    }

    @Nullable
    public View onCreateView(LayoutInflater layoutInflater, ViewGroup viewGroup, Bundle bundle) {
        this.mIsRecordingPermissionGranted = false;
        this.mRecordingTimer = new Timer();
        this.mRecorder = new com.instabug.library.internal.media.a(this.getArguments().getString(EXTRA_FILE_PATH));
        layoutInflater = layoutInflater.inflate(R.layout.instabug_lyt_record_audio, viewGroup, false);
        layoutInflater.findViewById(R.id.instabug_btn_record_audio).setOnTouchListener((View.OnTouchListener)this);
        this.mRecordButtonBackground = (ImageView)layoutInflater.findViewById(R.id.instabug_bk_record_audio);
        this.mRecordButtonIcon = (ImageView)layoutInflater.findViewById(R.id.instabug_img_record_audio);
        this.mColorFilter = new PorterDuffColorFilter(SettingsManager.getInstance().getPrimaryColor(), PorterDuff.Mode.SRC_IN);
        this.mRecordButtonBackground.setColorFilter((ColorFilter)this.mColorFilter);
        this.mRecordButtonIcon.setColorFilter((ColorFilter)this.mColorFilter);
        this.timerTextView = (TextView)layoutInflater.findViewById(R.id.instabug_txt_timer);
        this.timerTextView.setTextColor(Instabug.getPrimaryColor());
        this.timerTextView.setText((CharSequence)String.format("00:%02d", 0));
        this.titleTextView = (TextView)layoutInflater.findViewById(R.id.instabug_txt_recording_title);
        this.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_PRESS_AND_HOLD_TO_RECORD, this.getString(R.string.instabug_str_hold_to_record)));
        layoutInflater.findViewById(R.id.instabug_recording_audio_dialog_container).setOnClickListener((View.OnClickListener)this);
        return layoutInflater;
    }

    public void onViewCreated(View view, @Nullable Bundle bundle) {
        super.onViewCreated(view, bundle);
        this.requestAudioRecordingPermission();
    }

    public void onDetach() {
        super.onDetach();
        this.listener = null;
    }

    private void requestAudioRecordingPermission() {
        PermissionsUtils.requestPermission(this, "android.permission.RECORD_AUDIO", 1, new Runnable(this){
            private /* synthetic */ InstabugAudioRecordingFragment a;
            {
                this.a = instabugAudioRecordingFragment;
            }

            @Override
            public final void run() {
                if (this.a.isFirstPermissionRequested) {
                    InstabugSDKLogger.d((Object)this.a, "Shouldn't try to explain why get this permission, either first time or never again selected OR permission not in manifest");
                    Toast.makeText((Context)this.a.getContext(), (CharSequence)this.a.getPermissionDeniedMessage(), (int)0).show();
                    Instabug.setShouldAudioRecordingOptionAppear(false);
                    return;
                }
                this.a.isFirstPermissionRequested = true;
            }
        }, new Runnable(this){
            private /* synthetic */ InstabugAudioRecordingFragment a;
            {
                this.a = instabugAudioRecordingFragment;
            }

            @Override
            public final void run() {
                InstabugSDKLogger.d((Object)this.a, "Audio recording permission already granted before");
                this.a.mIsRecordingPermissionGranted = true;
            }
        });
    }

    public void onRequestPermissionsResult(int n, @NonNull String[] stringArray, @NonNull int[] nArray) {
        switch (n) {
            case 1: {
                if (nArray.length > 0 && nArray[0] == 0) {
                    InstabugSDKLogger.d((Object)this, "Audio recording permission granted by user");
                    this.mIsRecordingPermissionGranted = true;
                    return;
                }
                InstabugSDKLogger.d((Object)this, "Audio recording permission denied by user");
                this.mIsRecordingPermissionGranted = false;
                Toast.makeText((Context)this.getContext(), (CharSequence)this.getPermissionDeniedMessage(), (int)0).show();
                return;
            }
        }
        super.onRequestPermissionsResult(n, stringArray, nArray);
    }

    public boolean onTouch(View view, MotionEvent motionEvent) {
        switch (motionEvent.getAction()) {
            case 0: {
                if (!this.mIsRecordingActive && this.mIsRecordingPermissionGranted) {
                    this.mCurrentTime = 0;
                    this.mRecordingTimer.scheduleAtFixedRate(this.mTimerTask, 0L, 1000L);
                    this.mRecorder.a();
                    this.mIsRecordingActive = true;
                    this.setStateActive();
                    this.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_RELEASE_TO_ATTACH, this.getString(R.string.instabug_str_release_stop_record)));
                }
                if (this.mIsRecordingPermissionGranted) break;
                this.requestAudioRecordingPermission();
                break;
            }
            case 1: 
            case 3: {
                if (!this.mIsRecordingActive || !this.mIsRecordingPermissionGranted || !this.stopRecording() || motionEvent.getAction() != 1) break;
                this.finishRecording();
            }
        }
        return true;
    }

    private void finishRecording() {
        if (this.listener != null) {
            AudioPlayer audioPlayer = new AudioPlayer();
            audioPlayer.getDurationAsync(this.getArguments().getString(EXTRA_FILE_PATH), new AudioPlayer.b(this, audioPlayer){
                private /* synthetic */ AudioPlayer a;
                private /* synthetic */ InstabugAudioRecordingFragment b;
                {
                    this.b = instabugAudioRecordingFragment;
                    this.a = audioPlayer;
                }

                @Override
                public final void a(int n) {
                    this.a.release();
                    this.b.listener.onAudioRecorded(this.b.getArguments().getString(InstabugAudioRecordingFragment.EXTRA_FILE_PATH), AudioPlayer.getFormattedDurationText(n));
                    this.b.removeCurrentFragment();
                }
            });
        }
    }

    private boolean stopRecording() {
        try {
            this.mTimerTask.cancel();
            this.mRecordingTimer.cancel();
            this.mTimerTask = new a();
            this.mRecordingTimer = new Timer();
            this.mIsRecordingActive = false;
            this.setStateInactive();
            this.timerTextView.setText((CharSequence)String.format("00:%02d", 0));
            this.titleTextView.setText((CharSequence)PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.VOICE_MESSAGE_PRESS_AND_HOLD_TO_RECORD, this.getString(R.string.instabug_str_hold_to_record)));
            this.mRecorder.b();
            return this.mCurrentTime > 3;
        }
        catch (RuntimeException runtimeException) {
            if (this.mCurrentTime > 1) {
                Toast.makeText((Context)this.getActivity(), (CharSequence)"Unknown error occurred", (int)0).show();
            }
            InstabugSDKLogger.e((Object)this, "Error capturing audio stream", runtimeException);
            return false;
        }
    }

    private void setStateActive() {
        this.mRecordButtonBackground.setImageResource(R.drawable.instabug_bg_active_record);
        Colorizer.applyTint(-65536, this.mRecordButtonBackground);
        this.mRecordButtonIcon.setColorFilter(null);
        this.timerTextView.setTextColor(-65536);
    }

    private void setStateInactive() {
        this.mRecordButtonBackground.setImageResource(R.drawable.instabug_bg_default_record);
        this.mRecordButtonBackground.setColorFilter((ColorFilter)this.mColorFilter);
        this.mRecordButtonIcon.setColorFilter((ColorFilter)this.mColorFilter);
        this.timerTextView.setTextColor(Instabug.getPrimaryColor());
    }

    public void onClick(View view) {
        if (this.getFragmentManager() != null) {
            view = this.getFragmentManager().beginTransaction();
            view.remove((Fragment)this).commit();
            this.getFragmentManager().popBackStack();
        }
    }

    private String getPermissionDeniedMessage() {
        return PlaceHolderUtils.getPlaceHolder(InstabugCustomTextPlaceHolder.Key.AUDIO_RECORDING_PERMISSION_DENIED, this.getString(R.string.instabug_audio_recorder_permission_denied));
    }

    private void onTimeIsUp() {
        this.finishRecording();
    }

    private void removeCurrentFragment() {
        this.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)this).commit();
        this.getFragmentManager().popBackStack("Record Audio", 1);
    }

    final class a
    extends TimerTask {
        a() {
        }

        @Override
        public final void run() {
            InstabugAudioRecordingFragment.this.getActivity().runOnUiThread(new Runnable(this){
                private /* synthetic */ a a;
                {
                    this.a = a2;
                }

                @Override
                public final void run() {
                    if (this.a.InstabugAudioRecordingFragment.this.mCurrentTime >= 50) {
                        this.a.InstabugAudioRecordingFragment.this.timerTextView.setTextColor(Instabug.getPrimaryColor());
                    } else {
                        this.a.InstabugAudioRecordingFragment.this.timerTextView.setTextColor(-65536);
                    }
                    if (this.a.InstabugAudioRecordingFragment.this.mCurrentTime == 60) {
                        this.a.InstabugAudioRecordingFragment.this.onTimeIsUp();
                    }
                    this.a.InstabugAudioRecordingFragment.this.timerTextView.setText((CharSequence)AudioPlayer.getFormattedDurationText(this.a.InstabugAudioRecordingFragment.this.mCurrentTime * 1000));
                    this.a.InstabugAudioRecordingFragment.this.mCurrentTime++;
                }
            });
        }
    }

    public static interface Callbacks {
        public void onAudioRecorded(String var1, String var2);
    }
}

