/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.tracking;

import android.app.Activity;
import android.app.Application;
import android.app.Fragment;
import android.os.Build;
import android.support.annotation.Nullable;
import android.view.MotionEvent;
import com.instabug.library.Feature;
import com.instabug.library._InstabugActivity;
import com.instabug.library.b;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.model.d;
import com.instabug.library.tracking.ActivityLifeCycleEvent;
import com.instabug.library.tracking.a;
import com.instabug.library.tracking.c;
import com.instabug.library.tracking.d;
import com.instabug.library.util.InstabugSDKLogger;
import java.lang.ref.WeakReference;

public class InstabugInternalTrackingDelegate {
    private static InstabugInternalTrackingDelegate INSTANCE;
    private WeakReference<Activity> currentActivity;

    public static void init(Application application) {
        if (INSTANCE == null) {
            INSTANCE = new InstabugInternalTrackingDelegate(application);
        }
    }

    public static InstabugInternalTrackingDelegate getInstance() {
        return INSTANCE;
    }

    private InstabugInternalTrackingDelegate(Application application) {
        if (application != null) {
            this.registerActivityLifecycleListener(application);
        }
    }

    public void onApplicationCreated(Application application) {
        if (this.isUserTrackingStepsEnable()) {
            InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, application.getClass().getSimpleName() + " created");
            d.a().a(application.getClass().getName(), d.a.b);
        }
    }

    public void onActivityCreated(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityCreatedEvent(activity);
        }
    }

    void handleActivityCreatedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " created");
                d.a().a(activity.getClass().getName(), d.a.c);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(d.a.c, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.CREATED);
        }
    }

    public void onActivityStarted(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityStartedEvent(activity);
        }
    }

    void handleActivityStartedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " started");
                d.a().a(activity.getClass().getName(), d.a.d);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(d.a.d, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STARTED);
    }

    public void onActivityResumed(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityResumedEvent(activity);
        }
    }

    void handleActivityResumedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            this.currentActivity = new WeakReference<Activity>(activity);
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " resumed");
                d.a().a(activity.getClass().getName(), d.a.e);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(d.a.e, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.RESUMED);
        }
    }

    public void onActivityPaused(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityPausedEvent(activity);
        }
    }

    void handleActivityPausedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.currentActivity == null) {
                InstabugSDKLogger.w(this, "No activity was set earlier than this call. Doing nothing");
                return;
            }
            if (!activity.equals(this.currentActivity.get())) {
                InstabugSDKLogger.w(this, "You're trying to pause an activity that is not the current activity! Please make sure you're calling onCurrentActivityPaused and onCurrentActivityResumed on every activity");
                return;
            }
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " paused");
                d.a().a(activity.getClass().getName(), d.a.f);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(d.a.f, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.PAUSED);
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityStoppedEvent(activity);
        }
    }

    void handleActivityStoppedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " stopped");
                d.a().a(activity.getClass().getName(), d.a.g);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(d.a.g, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
        }
        CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.STOPPED);
    }

    public void onActivityDestroyed(Activity activity) {
        if (this.beforeICS()) {
            this.handleActivityDestroyedEvent(activity);
        }
    }

    void handleActivityDestroyedEvent(Activity activity) {
        if (this.isNotInstabugActivity(activity)) {
            if (this.isUserTrackingStepsEnable()) {
                InstabugSDKLogger.v(InstabugInternalTrackingDelegate.class, activity.getClass().getSimpleName() + " destroyed");
                d.a().a(activity.getClass().getName(), d.a.h);
            }
            if (this.isReproStepsEnable()) {
                com.instabug.library.visualusersteps.d.a().a(d.a.h, activity.getClass().getSimpleName(), activity.getClass().getName());
            }
            CurrentActivityLifeCycleEventBus.getInstance().post(ActivityLifeCycleEvent.DESTROYED);
        }
    }

    public void onFragmentAttached(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.j);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.j, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentViewCreated(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.k);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.k, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentStarted(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.l);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.l, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentResumed(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.m);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.m, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentPaused(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.n);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.n, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentStopped(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.o);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.o, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentDetached(Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.p);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.p, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentAttached(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.j);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.j, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentViewCreated(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.k);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.k, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentStarted(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.l);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.l, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentResumed(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.m);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.m, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentPaused(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.n);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.n, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentStopped(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.o);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.o, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentDetached(android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), d.a.p);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.p, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentVisibilityChanged(boolean bl, Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + bl, d.a.q);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.q, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void onFragmentVisibilityChanged(boolean bl, android.support.v4.app.Fragment fragment, Activity activity) {
        if (this.isUserTrackingStepsEnable()) {
            d.a().a(fragment.getClass().getName(), activity.getClass().getName(), "Fragment visibility: " + bl, d.a.q);
        }
        if (this.isReproStepsEnable()) {
            com.instabug.library.visualusersteps.d.a().a(d.a.q, fragment.getClass().getSimpleName(), fragment.getClass().getName());
        }
    }

    public void trackTouchEvent(MotionEvent motionEvent, Activity activity) {
        c.a().a(activity, motionEvent);
    }

    public Activity getCurrentActivity() {
        if (this.currentActivity != null && this.currentActivity.get() != null) {
            return (Activity)this.currentActivity.get();
        }
        return null;
    }

    @Nullable
    public Activity getTargetActivity() {
        Activity activity = null;
        if (this.currentActivity != null && this.currentActivity.get() != null && ((Activity)this.currentActivity.get()).getParent() != null) {
            activity = ((Activity)this.currentActivity.get()).getParent();
            while (activity.getParent() != null) {
                activity = activity.getParent();
            }
        } else if (this.currentActivity != null) {
            activity = (Activity)this.currentActivity.get();
        }
        return activity;
    }

    private void registerActivityLifecycleListener(Application application) {
        if (Build.VERSION.SDK_INT >= 14) {
            InstabugSDKLogger.v(this, "Registering activity lifecycle listener");
            a a2 = new a();
            application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)a2);
        }
    }

    private boolean beforeICS() {
        return Build.VERSION.SDK_INT < 14;
    }

    private boolean isUserTrackingStepsEnable() {
        return b.a().b(Feature.TRACK_USER_STEPS) == Feature.State.ENABLED;
    }

    private boolean isReproStepsEnable() {
        return b.a().b(Feature.REPRO_STEPS) == Feature.State.ENABLED;
    }

    private boolean isNotInstabugActivity(Activity activity) {
        return !(activity instanceof _InstabugActivity);
    }
}

