/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.device;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.text.TextUtils;
import com.instabug.library.util.InstabugSDKLogger;

public class InstabugDeviceProperties {
    public static String getAppVersion(Context context) {
        PackageInfo packageInfo = new PackageInfo();
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e(InstabugDeviceProperties.class, "failed to get app version", nameNotFoundException);
        }
        String string2 = String.format("%s (%s)", packageInfo.versionName, packageInfo.versionCode);
        return string2;
    }

    public static String getAppVersionName(Context context) {
        PackageInfo packageInfo = new PackageInfo();
        try {
            packageInfo = context.getPackageManager().getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            InstabugSDKLogger.e(InstabugDeviceProperties.class, "failed to get app version", nameNotFoundException);
        }
        String string2 = packageInfo.versionName;
        return string2;
    }

    public static String getPackageName(Context context) {
        String string2;
        try {
            string2 = context.getApplicationInfo().packageName;
        }
        catch (Exception exception) {
            string2 = "Could not get information";
            InstabugSDKLogger.e(InstabugDeviceProperties.class, "failed to get package name", exception);
        }
        return string2;
    }

    public static boolean isStoreVersion(Context context) {
        try {
            String string2 = context.getPackageManager().getInstallerPackageName(context.getPackageName());
            return !TextUtils.isEmpty((CharSequence)string2);
        }
        catch (Exception exception) {
            InstabugSDKLogger.e(InstabugDeviceProperties.class, "failed to get installer package name", exception);
            return false;
        }
    }

    public static String getDeviceType() {
        return Build.MANUFACTURER + " " + Build.MODEL;
    }

    public static int getCurrentOSLevel() {
        return Build.VERSION.SDK_INT;
    }

    public static boolean isTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 3;
    }
}

