/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.annotation;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugColorTheme;
import com.instabug.library.R;
import com.instabug.library.annotation.AnnotationView;
import com.instabug.library.annotation.ColorPickerPopUpView;
import com.instabug.library.annotation.ShapeSuggestionsLayout;
import com.instabug.library.util.AttrResolver;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.a;
import com.instabug.library.view.IconView;
import com.instabug.library.view.ViewUtils;

public class AnnotationLayout
extends LinearLayout
implements View.OnClickListener {
    private static final String TAG = "AnnotationLayout";
    private AnnotationView annotationView;
    private ColorPickerPopUpView colorPicker;
    private int tintingColor;
    private LinearLayout annotationActionsContainer;
    private RelativeLayout iconBrushLayout;
    private IconView iconBrush;
    private IconView iconMagnify;
    private IconView iconBlur;
    private IconView iconUndo;
    private View brushIndicator;
    private View border;
    private ShapeSuggestionsLayout shapeSuggestionsLayout;

    public AnnotationLayout(Context context) {
        this(context, null);
    }

    public AnnotationLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    @TargetApi(value=11)
    public AnnotationLayout(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.initViews();
    }

    @TargetApi(value=21)
    public AnnotationLayout(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.initViews();
    }

    private void initViews() {
        AnnotationLayout.inflate((Context)this.getContext(), (int)R.layout.instabug_annotation_view, (ViewGroup)this);
        this.annotationActionsContainer = (LinearLayout)this.findViewById(R.id.instabug_annotation_actions_container);
        this.shapeSuggestionsLayout = (ShapeSuggestionsLayout)this.findViewById(R.id.shapeSuggestionsLayout);
        this.shapeSuggestionsLayout.setOnShapeSelectedListener(new ShapeSuggestionsLayout.a(){

            @Override
            public void a(int n) {
                if (n == 1) {
                    AnnotationLayout.this.annotationView.a();
                }
            }
        });
        this.iconBrushLayout = (RelativeLayout)this.findViewById(R.id.icon_brush_layout);
        this.iconBrush = (IconView)this.findViewById(R.id.icon_brush);
        this.iconMagnify = (IconView)this.findViewById(R.id.icon_magnify);
        this.iconBlur = (IconView)this.findViewById(R.id.icon_blur);
        this.iconUndo = (IconView)this.findViewById(R.id.icon_undo);
        this.iconBrush.setEnabled(false);
        this.iconMagnify.setEnabled(false);
        this.iconBlur.setEnabled(false);
        this.iconUndo.setEnabled(false);
        this.border = this.findViewById(R.id.instabug_annotation_image_border);
        this.annotationView = (AnnotationView)this.findViewById(R.id.instabug_annotation_image);
        this.colorPicker = (ColorPickerPopUpView)this.findViewById(R.id.instabug_color_picker);
        this.brushIndicator = this.findViewById(R.id.brush_indicator);
        this.annotationView.setDrawingMode(AnnotationView.b.b);
        this.iconBrush.setTextColor(Instabug.getPrimaryColor());
        this.annotationView.setDrawingColor(this.colorPicker.getSelectedColor());
        this.annotationView.setOnActionDownListener(new AnnotationView.e(){

            @Override
            public void a() {
                if (AnnotationLayout.this.colorPicker.getVisibility() == 0) {
                    AnnotationLayout.this.colorPicker.setVisibility(8);
                }
                AnnotationLayout.this.shapeSuggestionsLayout.b();
            }
        });
        this.annotationView.setOnPathRecognizedListener(new AnnotationView.g(){

            @Override
            public void a(Path path, Path path2) {
                AnnotationLayout.this.showShapeSuggestions(new Path[]{path, path2});
            }
        });
        this.annotationView.setOnNewMagnifierAddingA\u0650\u0650\u0650bilityChangedListener(new AnnotationView.f(){

            @Override
            public void a(boolean bl) {
                AnnotationLayout.this.iconMagnify.setEnabled(bl);
            }
        });
        this.colorPicker.setOnColorSelectionListener(new ColorPickerPopUpView.b(){

            @Override
            public void a(@ColorInt int n, int n2) {
                AnnotationLayout.this.annotationView.setDrawingColor(n);
                AnnotationLayout.this.colorPicker.setVisibility(8);
                AnnotationLayout.this.brushIndicator.setBackgroundColor(n);
            }
        });
        this.colorPicker.setPopUpBackgroundColor(AttrResolver.getBackgroundColor(this.getContext()));
        this.colorPicker.setPopUpBorderColor(AttrResolver.getDividerColor(this.getContext()));
        this.iconBrushLayout.setOnClickListener((View.OnClickListener)this);
        this.iconMagnify.setOnClickListener(this);
        this.iconBlur.setOnClickListener(this);
        this.iconUndo.setOnClickListener(this);
        this.setViewSelector(this.iconMagnify);
        this.setViewSelector(this.iconUndo);
        this.tintingColor = Instabug.getTheme() == InstabugColorTheme.InstabugColorThemeLight ? ContextCompat.getColor((Context)this.getContext(), (int)R.color.instabug_theme_tinting_color_light) : ContextCompat.getColor((Context)this.getContext(), (int)R.color.instabug_theme_tinting_color_dark);
    }

    private void showShapeSuggestions(Path ... pathArray) {
        for (Path path : pathArray) {
            this.shapeSuggestionsLayout.a(path);
        }
        this.shapeSuggestionsLayout.a();
    }

    private void setBorder() {
        int n = ViewUtils.convertDpToPx(this.getContext(), 4.0f);
        int n2 = ViewUtils.convertDpToPx(this.getContext(), 2.0f);
        ShapeDrawable shapeDrawable = new ShapeDrawable();
        shapeDrawable.setShape((Shape)new RectShape());
        shapeDrawable.getPaint().setColor(Instabug.getPrimaryColor());
        shapeDrawable.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable.getPaint().setStrokeWidth((float)n);
        this.border.setPadding(n2, n2, n2, n2);
        if (Build.VERSION.SDK_INT >= 16) {
            this.border.setBackground((Drawable)shapeDrawable);
        } else {
            this.border.setBackgroundDrawable((Drawable)shapeDrawable);
        }
    }

    private void setViewSelector(final IconView iconView) {
        iconView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent motionEvent) {
                if (motionEvent.getAction() == 0) {
                    iconView.setTextColor(Instabug.getPrimaryColor());
                } else if (motionEvent.getAction() == 1) {
                    iconView.setTextColor(AnnotationLayout.this.tintingColor);
                }
                return false;
            }
        });
    }

    public void onClick(View view) {
        this.shapeSuggestionsLayout.b();
        int n = view.getId();
        if (n == R.id.icon_brush_layout) {
            if (this.iconBrush.getCurrentTextColor() == Instabug.getPrimaryColor()) {
                this.switchColorPickerVisibility();
            }
            this.annotationView.setDrawingMode(AnnotationView.b.b);
            this.resetColorSelection();
            this.iconBrush.setTextColor(Instabug.getPrimaryColor());
        } else if (n == R.id.icon_magnify) {
            this.annotationView.b();
            this.hideColorPicker();
        } else if (n == R.id.icon_blur) {
            this.annotationView.setDrawingMode(AnnotationView.b.e);
            this.resetColorSelection();
            this.iconBlur.setTextColor(Instabug.getPrimaryColor());
            this.hideColorPicker();
        } else if (n == R.id.icon_undo) {
            this.annotationView.d();
            this.hideColorPicker();
        }
    }

    private void switchColorPickerVisibility() {
        this.colorPicker.setVisibility(this.colorPicker.getVisibility() == 0 ? 8 : 0);
    }

    private void hideColorPicker() {
        if (this.colorPicker.getVisibility() == 0) {
            this.colorPicker.setVisibility(8);
        }
    }

    private void resetColorSelection() {
        int n = this.annotationActionsContainer.getChildCount();
        for (int i = 0; i < n; ++i) {
            if (!(this.annotationActionsContainer.getChildAt(i) instanceof IconView)) continue;
            ((TextView)this.annotationActionsContainer.getChildAt(i)).setTextColor(this.tintingColor);
        }
        this.iconBrush.setTextColor(this.tintingColor);
    }

    public void setBaseImage(@NonNull Uri uri, final @Nullable Runnable runnable) {
        BitmapUtils.loadBitmap(uri.getPath(), this.annotationView, new a.a(){

            @Override
            public void a() {
                AnnotationLayout.this.enableButtons();
                AnnotationLayout.this.setBorder();
                if (runnable != null) {
                    runnable.run();
                }
            }
        });
    }

    private void enableButtons() {
        this.iconBrush.setEnabled(true);
        this.iconMagnify.setEnabled(true);
        this.iconBlur.setEnabled(true);
        this.iconUndo.setEnabled(true);
    }

    @Nullable
    public Bitmap getAnnotatedBitmap() {
        return this.annotationView.c();
    }
}

