/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.support.annotation.NonNull;
import android.util.Log;
import com.instabug.library.settings.SettingsManager;

public final class InstabugSDKLogger {
    private static final String LOG_TAG = "INSTABUG - ";

    private InstabugSDKLogger() {
    }

    public static String logTag(@NonNull Object object) {
        String string2 = object instanceof Class ? ((Class)object).getSimpleName() : object.getClass().getSimpleName();
        return LOG_TAG + string2;
    }

    public static void v(@NonNull Object object, @NonNull String string2) {
        if (SettingsManager.getInstance().isDebugEnabled()) {
            String string3 = InstabugSDKLogger.logTag(object);
            if (string2.length() > 4000) {
                int n = string2.length() / 4000;
                Log.v((String)string3, (String)("logMessage length = " + string2.length() + " divided to " + (n + 1) + " chunks"));
                for (int i = 0; i <= n; ++i) {
                    int n2 = 4000 * (i + 1);
                    String string4 = n2 >= string2.length() ? string2.substring(4000 * i) : string2.substring(4000 * i, n2);
                    Log.v((String)string3, (String)("chunk " + (i + 1) + " of " + (n + 1) + ":\n" + string4));
                }
            } else {
                Log.v((String)string3, (String)string2);
            }
        }
    }

    public static void d(@NonNull Object object, @NonNull String string2) {
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        String string3 = InstabugSDKLogger.logTag(object);
        if (string2.length() > 4000) {
            int n = string2.length() / 4000;
            Log.d((String)string3, (String)("logMessage length = " + string2.length() + " divided to " + (n + 1) + " chunks"));
            for (int i = 0; i <= n; ++i) {
                int n2 = 4000 * (i + 1);
                String string4 = n2 >= string2.length() ? string2.substring(4000 * i) : string2.substring(4000 * i, n2);
                Log.d((String)string3, (String)("chunk " + (i + 1) + " of " + (n + 1) + ":\n" + string4));
            }
        } else {
            Log.d((String)string3, (String)string2);
        }
    }

    public static void i(@NonNull Object object, @NonNull String string2) {
        if (SettingsManager.getInstance().isDebugEnabled()) {
            Log.i((String)InstabugSDKLogger.logTag(object), (String)string2);
        }
    }

    public static void w(@NonNull Object object, @NonNull String string2) {
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.w((String)InstabugSDKLogger.logTag(object), (String)string2);
    }

    public static void e(@NonNull Object object, @NonNull String string2) {
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.e((String)InstabugSDKLogger.logTag(object), (String)string2);
    }

    public static void e(@NonNull Object object, @NonNull String string2, @NonNull Throwable throwable) {
        if (SettingsManager.getInstance().isDebugEnabled()) {
            Log.e((String)InstabugSDKLogger.logTag(object), (String)string2, (Throwable)throwable);
        }
    }

    public static void wtf(@NonNull Object object, @NonNull String string2) {
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.wtf((String)InstabugSDKLogger.logTag(object), (String)string2);
    }

    public static void wtf(@NonNull Object object, @NonNull String string2, @NonNull Throwable throwable) {
        if (!SettingsManager.getInstance().isDebugEnabled()) {
            return;
        }
        Log.wtf((String)InstabugSDKLogger.logTag(object), (String)string2, (Throwable)throwable);
    }
}

