/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.ui.custom;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.method.TransformationMethod;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;

public class InstabugAutoResizeTextView
extends TextView {
    private static final int NO_LINE_LIMIT = -1;
    private final RectF _availableSpaceRect = new RectF();
    private final SizeTester _sizeTester;
    private float _maxTextSize;
    private float _spacingMult = 1.0f;
    private float _spacingAdd = 0.0f;
    private float _minTextSize = TypedValue.applyDimension((int)2, (float)12.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
    private int _widthLimit;
    private int _maxLines;
    private boolean _initialized = false;
    private TextPaint _paint;

    public InstabugAutoResizeTextView(Context context) {
        this(context, null, 16842884);
    }

    public InstabugAutoResizeTextView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16842884);
    }

    public InstabugAutoResizeTextView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this._maxTextSize = this.getTextSize();
        this._paint = new TextPaint((Paint)this.getPaint());
        if (this._maxLines == 0) {
            this._maxLines = -1;
        }
        this._sizeTester = new SizeTester(){
            final RectF textRect = new RectF();

            @Override
            @TargetApi(value=16)
            public int onTestSize(int n, RectF rectF) {
                boolean bl;
                InstabugAutoResizeTextView.this._paint.setTextSize((float)n);
                TransformationMethod transformationMethod = InstabugAutoResizeTextView.this.getTransformationMethod();
                String string2 = transformationMethod != null ? transformationMethod.getTransformation(InstabugAutoResizeTextView.this.getText(), (View)InstabugAutoResizeTextView.this).toString() : InstabugAutoResizeTextView.this.getText().toString();
                boolean bl2 = bl = InstabugAutoResizeTextView.this.getMaxLines() == 1;
                if (bl) {
                    this.textRect.bottom = InstabugAutoResizeTextView.this._paint.getFontSpacing();
                    this.textRect.right = InstabugAutoResizeTextView.this._paint.measureText(string2);
                } else {
                    StaticLayout staticLayout = new StaticLayout((CharSequence)string2, InstabugAutoResizeTextView.this._paint, InstabugAutoResizeTextView.this._widthLimit, Layout.Alignment.ALIGN_NORMAL, InstabugAutoResizeTextView.this._spacingMult, InstabugAutoResizeTextView.this._spacingAdd, true);
                    if (InstabugAutoResizeTextView.this.getMaxLines() != -1 && staticLayout.getLineCount() > InstabugAutoResizeTextView.this.getMaxLines()) {
                        return 1;
                    }
                    this.textRect.bottom = staticLayout.getHeight();
                    int n2 = -1;
                    int n3 = staticLayout.getLineCount();
                    for (int i = 0; i < n3; ++i) {
                        int n4 = staticLayout.getLineEnd(i);
                        if (i < n3 - 1 && n4 > 0 && n4 - 1 < string2.length() && !InstabugAutoResizeTextView.this.isValidWordWrap(string2.charAt(n4 - 1))) {
                            return 1;
                        }
                        if (!((float)n2 < staticLayout.getLineRight(i) - staticLayout.getLineLeft(i))) continue;
                        n2 = (int)staticLayout.getLineRight(i) - (int)staticLayout.getLineLeft(i);
                    }
                    this.textRect.right = n2;
                }
                this.textRect.offsetTo(0.0f, 0.0f);
                if (rectF.contains(this.textRect)) {
                    return -1;
                }
                return 1;
            }
        };
        this._initialized = true;
    }

    public boolean isValidWordWrap(char c2) {
        return c2 == ' ' || c2 == '-' || c2 == '\n';
    }

    public void setAllCaps(boolean bl) {
        super.setAllCaps(bl);
        this.adjustTextSize();
    }

    public void setTypeface(Typeface typeface) {
        super.setTypeface(typeface);
        this.adjustTextSize();
    }

    public void setTextSize(float f2) {
        this._maxTextSize = f2;
        this.adjustTextSize();
    }

    public void setMaxLines(int n) {
        super.setMaxLines(n);
        this._maxLines = n;
        this.adjustTextSize();
    }

    public int getMaxLines() {
        return this._maxLines;
    }

    public void setSingleLine() {
        super.setSingleLine();
        this._maxLines = 1;
        this.adjustTextSize();
    }

    public void setSingleLine(boolean bl) {
        super.setSingleLine(bl);
        this._maxLines = bl ? 1 : -1;
        this.adjustTextSize();
    }

    public void setLines(int n) {
        super.setLines(n);
        this._maxLines = n;
        this.adjustTextSize();
    }

    public void setTextSize(int n, float f2) {
        Context context = this.getContext();
        Resources resources = context == null ? Resources.getSystem() : context.getResources();
        this._maxTextSize = TypedValue.applyDimension((int)n, (float)f2, (DisplayMetrics)resources.getDisplayMetrics());
        this.adjustTextSize();
    }

    public void setLineSpacing(float f2, float f3) {
        super.setLineSpacing(f2, f3);
        this._spacingMult = f3;
        this._spacingAdd = f2;
    }

    public void setMinTextSize(float f2) {
        this._minTextSize = f2;
        this.adjustTextSize();
    }

    private void adjustTextSize() {
        if (!this._initialized) {
            return;
        }
        int n = (int)this._minTextSize;
        int n2 = this.getMeasuredHeight() - this.getCompoundPaddingBottom() - this.getCompoundPaddingTop();
        this._widthLimit = this.getMeasuredWidth() - this.getCompoundPaddingLeft() - this.getCompoundPaddingRight();
        if (this._widthLimit <= 0) {
            return;
        }
        this._paint = new TextPaint((Paint)this.getPaint());
        this._availableSpaceRect.right = this._widthLimit;
        this._availableSpaceRect.bottom = n2;
        this.superSetTextSize(n);
    }

    private void superSetTextSize(int n) {
        int n2 = this.binarySearch(n, (int)this._maxTextSize, this._sizeTester, this._availableSpaceRect);
        super.setTextSize(0, (float)n2);
    }

    private int binarySearch(int n, int n2, SizeTester sizeTester, RectF rectF) {
        int n3 = n;
        int n4 = n;
        int n5 = n2 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            int n7 = sizeTester.onTestSize(n6, rectF);
            if (n7 < 0) {
                n3 = n4;
                n4 = n6 + 1;
                continue;
            }
            if (n7 > 0) {
                n3 = n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return n3;
    }

    protected void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        super.onTextChanged(charSequence, n, n2, n3);
        this.adjustTextSize();
    }

    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        super.onSizeChanged(n, n2, n3, n4);
        if (n != n3 || n2 != n4) {
            this.adjustTextSize();
        }
    }

    private static interface SizeTester {
        public int onTestSize(int var1, RectF var2);
    }
}

