/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.model;

import android.annotation.TargetApi;
import android.app.ActivityManager;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import android.os.Environment;
import android.telephony.TelephonyManager;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import com.instabug.library.Feature;
import com.instabug.library.e;
import com.instabug.library.internal.device.InstabugDeviceProperties;
import com.instabug.library.internal.storage.cache.Cacheable;
import com.instabug.library.internal.storage.cache.UserAttributesCacheManager;
import com.instabug.library.logging.InstabugLog;
import com.instabug.library.logging.InstabugUserEventLogger;
import com.instabug.library.model.NetworkLog;
import com.instabug.library.model.a;
import com.instabug.library.model.b;
import com.instabug.library.model.c;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.d;
import com.instabug.library.user.UserEvent;
import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class State
implements Cacheable,
Serializable {
    public static final String KEY_APP_PACKAGE_NAME = "bundle_id";
    public static final String KEY_APP_VERSION = "app_version";
    public static final String KEY_BATTERY_LEVEL = "battery_level";
    public static final String KEY_BATTERY_STATUS = "battery_state";
    public static final String KEY_CARRIER = "carrier";
    public static final String KEY_CONSOLE_LOG = "console_log";
    public static final String KEY_CURRENT_VIEW = "current_view";
    public static final String KEY_DENSITY = "density";
    public static final String KEY_DEVICE = "device";
    public static final String KEY_DEVICE_ROOTED = "device_rooted";
    public static final String KEY_DURATION = "duration";
    public static final String KEY_EMAIL = "email";
    public static final String KEY_INSTABUG_LOG = "instabug_log";
    public static final String KEY_LOCALE = "locale";
    public static final String KEY_MEMORY_FREE = "memory_free";
    public static final String KEY_MEMORY_TOTAL = "memory_total";
    public static final String KEY_MEMORY_USED = "memory_used";
    public static final String KEY_ORIENTATION = "orientation";
    public static final String KEY_OS = "os";
    public static final String KEY_REPORTED_AT = "reported_at";
    public static final String KEY_SCREEN_SIZE = "screen_size";
    public static final String KEY_SDK_VERSION = "sdk_version";
    public static final String KEY_STORAGE_FREE = "storage_free";
    public static final String KEY_STORAGE_TOTAL = "storage_total";
    public static final String KEY_STORAGE_USED = "storage_used";
    public static final String KEY_TAGS = "tags";
    public static final String KEY_USER_DATA = "user_data";
    public static final String KEY_USER_STEPS = "user_steps";
    public static final String KEY_WIFI_SSID = "wifi_ssid";
    public static final String KEY_WIFI_STATE = "wifi_state";
    public static final String KEY_USER_ATTRIBUTES = "user_attributes";
    public static final String KEY_NETWORK_LOGS = "network_log";
    public static final String KEY_USER_EVENTS = "user_events";
    public static final String KEY_VISUAL_USER_STEPS = "user_repro_steps";
    private String sdkVersion;
    private String locale;
    private long duration;
    private String device;
    private boolean isDeviceRooted;
    private String OS;
    private String carrier;
    private String appPackageName;
    private String appVersion;
    private int batteryLevel;
    private String batteryState;
    private boolean wifiState;
    private String wifiSSID;
    private long usedMemory;
    private long freeMemory;
    private long totalMemory;
    private long usedStorage;
    private long freeStorage;
    private long totalStorage;
    private String screenDensity;
    private String screenSize;
    private String ScreenOrientation;
    private String currentView;
    private String instabugLog;
    private ArrayList<a> consoleLog;
    private ArrayList<c> userSteps;
    private ArrayList<com.instabug.library.visualusersteps.b> visualUserSteps;
    private String userEmail;
    private String userData;
    private long reportedAt;
    private String tags;
    private String networkLogs;
    private String userAttributes;
    private String userEvents;

    public String getSdkVersion() {
        return this.sdkVersion;
    }

    public State setSdkVersion(String string2) {
        this.sdkVersion = string2;
        return this;
    }

    public String getLocale() {
        return this.locale;
    }

    public State setLocale(String string2) {
        this.locale = string2;
        return this;
    }

    public long getDuration() {
        return this.duration;
    }

    public State setDuration(long l) {
        this.duration = l;
        return this;
    }

    public String getDevice() {
        return this.device;
    }

    public State setDevice(String string2) {
        this.device = string2;
        return this;
    }

    public boolean isDeviceRooted() {
        return this.isDeviceRooted;
    }

    public State setIsDeviceRooted(boolean bl) {
        this.isDeviceRooted = bl;
        return this;
    }

    public String getOS() {
        return this.OS;
    }

    public State setOS(String string2) {
        this.OS = string2;
        return this;
    }

    public String getCarrier() {
        return this.carrier;
    }

    public State setCarrier(String string2) {
        this.carrier = string2;
        return this;
    }

    public String getAppPackageName() {
        return this.appPackageName;
    }

    public State setAppPackageName(String string2) {
        this.appPackageName = string2;
        return this;
    }

    public String getAppVersion() {
        return this.appVersion;
    }

    public State setAppVersion(String string2) {
        this.appVersion = string2;
        return this;
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public State setBatteryLevel(int n) {
        this.batteryLevel = n;
        return this;
    }

    public String getBatteryState() {
        return this.batteryState;
    }

    public State setBatteryState(String string2) {
        this.batteryState = string2;
        return this;
    }

    public boolean isWifiEnable() {
        return this.wifiState;
    }

    public State setWifiState(boolean bl) {
        this.wifiState = bl;
        return this;
    }

    public String getWifiSSID() {
        return this.wifiSSID;
    }

    public State setWifiSSID(String string2) {
        this.wifiSSID = string2;
        return this;
    }

    public long getUsedMemory() {
        return this.usedMemory;
    }

    public State setUsedMemory(long l) {
        this.usedMemory = l;
        return this;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public State setFreeMemory(long l) {
        this.freeMemory = l;
        return this;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public State setTotalMemory(long l) {
        this.totalMemory = l;
        return this;
    }

    public long getUsedStorage() {
        return this.usedStorage;
    }

    public State setUsedStorage(long l) {
        this.usedStorage = l;
        return this;
    }

    public long getFreeStorage() {
        return this.freeStorage;
    }

    public State setFreeStorage(long l) {
        this.freeStorage = l;
        return this;
    }

    public long getTotalStorage() {
        return this.totalStorage;
    }

    public State setTotalStorage(long l) {
        this.totalStorage = l;
        return this;
    }

    public String getScreenDensity() {
        return this.screenDensity;
    }

    public State setScreenDensity(String string2) {
        this.screenDensity = string2;
        return this;
    }

    public String getScreenSize() {
        return this.screenSize;
    }

    public State setScreenSize(String string2) {
        this.screenSize = string2;
        return this;
    }

    public String getScreenOrientation() {
        return this.ScreenOrientation;
    }

    public State setScreenOrientation(String string2) {
        this.ScreenOrientation = string2;
        return this;
    }

    public String getCurrentView() {
        return this.currentView;
    }

    public State setCurrentView(String string2) {
        this.currentView = string2;
        return this;
    }

    public String getInstabugLog() {
        return this.instabugLog;
    }

    public State setInstabugLog(String string2) {
        this.instabugLog = string2;
        return this;
    }

    public void updateConsoleLog() {
        this.setConsoleLog(Builder.getConsoleLog());
    }

    public JSONArray getConsoleLog() {
        return a.a(this.consoleLog);
    }

    public State setConsoleLog(ArrayList<a> arrayList) {
        this.consoleLog = arrayList;
        return this;
    }

    public JSONArray getUserSteps() {
        return c.a(this.userSteps);
    }

    public State setUserSteps(ArrayList<c> arrayList) {
        this.userSteps = arrayList;
        return this;
    }

    public String getUserEmail() {
        return this.userEmail;
    }

    public State setUserEmail(String string2) {
        this.userEmail = string2;
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public State setUserData(String string2) {
        this.userData = string2;
        return this;
    }

    public long getReportedAt() {
        return this.reportedAt;
    }

    public State setReportedAt(long l) {
        this.reportedAt = l;
        return this;
    }

    public String getTags() {
        return this.tags;
    }

    public State setTags(String string2) {
        this.tags = string2;
        return this;
    }

    public String getUserAttributes() {
        return this.userAttributes;
    }

    public State setUserAttributes(String string2) {
        this.userAttributes = string2;
        return this;
    }

    public String getNetworkLogs() {
        return this.networkLogs;
    }

    public State setNetworkLogs(String string2) {
        this.networkLogs = string2;
        return this;
    }

    public String getUserEvents() {
        return this.userEvents;
    }

    public State setUserEvents(String string2) {
        this.userEvents = string2;
        return this;
    }

    public String getVisualUserSteps() {
        return com.instabug.library.visualusersteps.b.a(this.visualUserSteps);
    }

    public State setVisualUserSteps(ArrayList<com.instabug.library.visualusersteps.b> arrayList) {
        this.visualUserSteps = arrayList;
        return this;
    }

    public ArrayList<StateItem> getStateItems() throws JSONException {
        ArrayList<StateItem> arrayList = new ArrayList<StateItem>();
        arrayList.add(new StateItem().setKey(KEY_APP_PACKAGE_NAME).setValue(this.getAppPackageName()));
        arrayList.add(new StateItem().setKey(KEY_APP_VERSION).setValue(this.getAppVersion()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_LEVEL).setValue(this.getBatteryLevel()));
        arrayList.add(new StateItem().setKey(KEY_BATTERY_STATUS).setValue(this.getBatteryState()));
        arrayList.add(new StateItem().setKey(KEY_CARRIER).setValue(this.getCarrier()));
        arrayList.add(new StateItem().setKey(KEY_CURRENT_VIEW).setValue(this.getCurrentView()));
        arrayList.add(new StateItem().setKey(KEY_DENSITY).setValue(this.getScreenDensity()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE).setValue(this.getDevice()));
        arrayList.add(new StateItem().setKey(KEY_DEVICE_ROOTED).setValue(this.isDeviceRooted()));
        arrayList.add(new StateItem().setKey(KEY_DURATION).setValue(this.getDuration()));
        arrayList.add(new StateItem().setKey(KEY_EMAIL).setValue(this.getUserEmail()));
        arrayList.add(new StateItem().setKey(KEY_LOCALE).setValue(this.getLocale()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_FREE).setValue(this.getFreeMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_TOTAL).setValue(this.getTotalMemory()));
        arrayList.add(new StateItem().setKey(KEY_MEMORY_USED).setValue(this.getUsedMemory()));
        arrayList.add(new StateItem().setKey(KEY_ORIENTATION).setValue(this.getScreenOrientation()));
        arrayList.add(new StateItem().setKey(KEY_OS).setValue(this.getOS()));
        arrayList.add(new StateItem().setKey(KEY_REPORTED_AT).setValue(this.getReportedAt()));
        arrayList.add(new StateItem().setKey(KEY_SCREEN_SIZE).setValue(this.getScreenSize()));
        arrayList.add(new StateItem().setKey(KEY_SDK_VERSION).setValue(this.getSdkVersion()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_FREE).setValue(this.getFreeStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_TOTAL).setValue(this.getTotalStorage()));
        arrayList.add(new StateItem().setKey(KEY_STORAGE_USED).setValue(this.getUsedStorage()));
        arrayList.add(new StateItem().setKey(KEY_TAGS).setValue(this.getTags()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_SSID).setValue(this.getWifiSSID()));
        arrayList.add(new StateItem().setKey(KEY_WIFI_STATE).setValue(this.isWifiEnable()));
        arrayList.add(new StateItem().setKey(KEY_USER_ATTRIBUTES).setValue(this.getUserAttributes()));
        return arrayList;
    }

    public ArrayList<StateItem> getLogsItems() {
        ArrayList<StateItem> arrayList = new ArrayList<StateItem>();
        arrayList.add(new StateItem().setKey(KEY_CONSOLE_LOG).setValue(this.getConsoleLog().toString()));
        arrayList.add(new StateItem().setKey(KEY_INSTABUG_LOG).setValue(this.getInstabugLog()));
        arrayList.add(new StateItem().setKey(KEY_USER_DATA).setValue(this.getUserData()));
        arrayList.add(new StateItem().setKey(KEY_NETWORK_LOGS).setValue(this.getNetworkLogs()));
        arrayList.add(new StateItem().setKey(KEY_USER_EVENTS).setValue(this.getUserEvents()));
        if (com.instabug.library.b.a().b(Feature.TRACK_USER_STEPS) == Feature.State.ENABLED) {
            arrayList.add(new StateItem().setKey(KEY_USER_STEPS).setValue(this.getUserSteps().toString()));
        }
        if (com.instabug.library.b.a().b(Feature.REPRO_STEPS) == Feature.State.ENABLED) {
            arrayList.add(new StateItem().setKey(KEY_VISUAL_USER_STEPS).setValue(this.getVisualUserSteps()));
        }
        return arrayList;
    }

    @Override
    public String toJson() throws JSONException {
        JSONObject jSONObject = new JSONObject();
        ArrayList<StateItem> arrayList = this.getStateItems();
        for (int i = 0; i < arrayList.size(); ++i) {
            jSONObject.put(arrayList.get(i).getKey(), arrayList.get(i).getValue());
        }
        ArrayList<StateItem> arrayList2 = this.getLogsItems();
        for (int i = 0; i < arrayList2.size(); ++i) {
            jSONObject.put(arrayList2.get(i).getKey(), arrayList2.get(i).getValue());
        }
        InstabugSDKLogger.v(this, jSONObject.toString());
        return jSONObject.toString();
    }

    @Override
    public void fromJson(String string2) throws JSONException {
        JSONObject jSONObject = new JSONObject(string2);
        if (jSONObject.has(KEY_APP_PACKAGE_NAME)) {
            this.setAppPackageName(jSONObject.getString(KEY_APP_PACKAGE_NAME));
        }
        if (jSONObject.has(KEY_APP_VERSION)) {
            this.setAppVersion(jSONObject.getString(KEY_APP_VERSION));
        }
        if (jSONObject.has(KEY_BATTERY_LEVEL)) {
            this.setBatteryLevel(jSONObject.getInt(KEY_BATTERY_LEVEL));
        }
        if (jSONObject.has(KEY_BATTERY_STATUS)) {
            this.setBatteryState(jSONObject.getString(KEY_BATTERY_STATUS));
        }
        if (jSONObject.has(KEY_CARRIER)) {
            this.setCarrier(jSONObject.getString(KEY_CARRIER));
        }
        if (jSONObject.has(KEY_CONSOLE_LOG)) {
            this.setConsoleLog(a.a(new JSONArray(jSONObject.getString(KEY_CONSOLE_LOG))));
        }
        if (jSONObject.has(KEY_CURRENT_VIEW)) {
            this.setCurrentView(jSONObject.getString(KEY_CURRENT_VIEW));
        }
        if (jSONObject.has(KEY_DENSITY)) {
            this.setScreenDensity(jSONObject.getString(KEY_DENSITY));
        }
        if (jSONObject.has(KEY_DEVICE)) {
            this.setDevice(jSONObject.getString(KEY_DEVICE));
        }
        if (jSONObject.has(KEY_DEVICE_ROOTED)) {
            this.setIsDeviceRooted(jSONObject.getBoolean(KEY_DEVICE_ROOTED));
        }
        if (jSONObject.has(KEY_DURATION)) {
            this.setDuration(jSONObject.getLong(KEY_DURATION));
        }
        if (jSONObject.has(KEY_EMAIL)) {
            this.setUserEmail(jSONObject.getString(KEY_EMAIL));
        }
        if (jSONObject.has(KEY_INSTABUG_LOG)) {
            this.setInstabugLog(jSONObject.getString(KEY_INSTABUG_LOG));
        }
        if (jSONObject.has(KEY_LOCALE)) {
            this.setLocale(jSONObject.getString(KEY_LOCALE));
        }
        if (jSONObject.has(KEY_MEMORY_FREE)) {
            this.setFreeMemory(jSONObject.getLong(KEY_MEMORY_FREE));
        }
        if (jSONObject.has(KEY_MEMORY_TOTAL)) {
            this.setTotalMemory(jSONObject.getLong(KEY_MEMORY_TOTAL));
        }
        if (jSONObject.has(KEY_MEMORY_USED)) {
            this.setUsedMemory(jSONObject.getLong(KEY_MEMORY_USED));
        }
        if (jSONObject.has(KEY_ORIENTATION)) {
            this.setScreenOrientation(jSONObject.getString(KEY_ORIENTATION));
        }
        if (jSONObject.has(KEY_OS)) {
            this.setOS(jSONObject.getString(KEY_OS));
        }
        if (jSONObject.has(KEY_REPORTED_AT)) {
            this.setReportedAt(jSONObject.getLong(KEY_REPORTED_AT));
        }
        if (jSONObject.has(KEY_SCREEN_SIZE)) {
            this.setScreenSize(jSONObject.getString(KEY_SCREEN_SIZE));
        }
        if (jSONObject.has(KEY_SDK_VERSION)) {
            this.setSdkVersion(jSONObject.getString(KEY_SDK_VERSION));
        }
        if (jSONObject.has(KEY_STORAGE_FREE)) {
            this.setFreeStorage(jSONObject.getLong(KEY_STORAGE_FREE));
        }
        if (jSONObject.has(KEY_STORAGE_TOTAL)) {
            this.setTotalStorage(jSONObject.getLong(KEY_STORAGE_TOTAL));
        }
        if (jSONObject.has(KEY_STORAGE_USED)) {
            this.setUsedStorage(jSONObject.getLong(KEY_STORAGE_USED));
        }
        if (jSONObject.has(KEY_TAGS)) {
            this.setTags(jSONObject.getString(KEY_TAGS));
        }
        if (jSONObject.has(KEY_USER_DATA)) {
            this.setUserData(jSONObject.getString(KEY_USER_DATA));
        }
        if (jSONObject.has(KEY_USER_STEPS)) {
            this.setUserSteps(c.a(new JSONArray(jSONObject.getString(KEY_USER_STEPS))));
        }
        if (jSONObject.has(KEY_WIFI_SSID)) {
            this.setWifiSSID(jSONObject.getString(KEY_WIFI_SSID));
        }
        if (jSONObject.has(KEY_WIFI_STATE)) {
            this.setWifiState(jSONObject.getBoolean(KEY_WIFI_STATE));
        }
        if (jSONObject.has(KEY_USER_ATTRIBUTES)) {
            this.setUserAttributes(jSONObject.getString(KEY_USER_ATTRIBUTES));
        }
        if (jSONObject.has(KEY_NETWORK_LOGS)) {
            this.setNetworkLogs(jSONObject.getString(KEY_NETWORK_LOGS));
        }
        if (jSONObject.has(KEY_USER_EVENTS)) {
            this.setUserEvents(jSONObject.getString(KEY_USER_EVENTS));
        }
        if (jSONObject.has(KEY_VISUAL_USER_STEPS)) {
            this.setVisualUserSteps(com.instabug.library.visualusersteps.b.a(new JSONArray(jSONObject.getString(KEY_VISUAL_USER_STEPS))));
        }
    }

    public String toString() {
        try {
            return this.toJson();
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
            InstabugSDKLogger.e(this, "Something went wrong while getting state.toString()" + jSONException.getMessage(), jSONException);
            return "error";
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof State) {
            State state = (State)object;
            return String.valueOf(state.getAppVersion()).equals(String.valueOf(this.getAppVersion())) && state.getBatteryLevel() == this.getBatteryLevel() && String.valueOf(state.getBatteryState()).equals(String.valueOf(this.getBatteryState())) && String.valueOf(state.getCarrier()).equals(String.valueOf(this.getCarrier())) && String.valueOf(state.getConsoleLog()).equals(String.valueOf(this.getConsoleLog())) && String.valueOf(state.getCurrentView()).equals(String.valueOf(this.getCurrentView())) && state.getDuration() == this.getDuration() && String.valueOf(state.getDevice()).equals(String.valueOf(this.getDevice())) && state.getFreeMemory() == this.getFreeMemory() && state.getFreeStorage() == this.getFreeStorage() && String.valueOf(state.getLocale()).equals(String.valueOf(this.getLocale())) && String.valueOf(state.getOS()).equals(String.valueOf(this.getOS())) && state.getReportedAt() == this.getReportedAt() && String.valueOf(state.getScreenDensity()).equals(String.valueOf(this.getScreenDensity())) && String.valueOf(state.getScreenOrientation()).equals(String.valueOf(this.getScreenOrientation())) && String.valueOf(state.getScreenSize()).equals(String.valueOf(this.getScreenSize())) && String.valueOf(state.getSdkVersion()).equals(String.valueOf(this.getSdkVersion())) && state.getTotalMemory() == this.getTotalMemory() && state.getTotalStorage() == this.getTotalStorage() && String.valueOf(state.getTags()).equals(String.valueOf(this.getTags())) && state.getUsedMemory() == this.getUsedMemory() && state.getUsedStorage() == this.getUsedStorage() && String.valueOf(state.getUserData()).equals(String.valueOf(this.getUserData())) && String.valueOf(state.getUserEmail()).equals(String.valueOf(this.getUserEmail())) && String.valueOf(state.getUserSteps()).equals(String.valueOf(this.getUserSteps())) && String.valueOf(state.getWifiSSID()).equals(String.valueOf(this.getWifiSSID())) && state.isDeviceRooted() == this.isDeviceRooted() && state.isWifiEnable() == this.isWifiEnable() && String.valueOf(state.getInstabugLog()).equals(String.valueOf(this.getInstabugLog())) && String.valueOf(state.getUserAttributes()).equals(String.valueOf(this.getUserAttributes())) && String.valueOf(state.getNetworkLogs()).equals(String.valueOf(this.getNetworkLogs())) && String.valueOf(state.getUserEvents()).equals(String.valueOf(this.getUserEvents())) && String.valueOf(state.getVisualUserSteps()).equals(String.valueOf(this.getVisualUserSteps()));
        }
        return false;
    }

    public int hashCode() {
        return String.valueOf(this.getReportedAt()).hashCode();
    }

    public static class Builder
    implements Serializable {
        private Context context;

        public Builder(Context context) {
            this.context = context;
        }

        private static ArrayList<a> getConsoleLog() {
            ArrayList<a> arrayList = new ArrayList<a>();
            if (com.instabug.library.b.a().b(Feature.CONSOLE_LOGS) == Feature.State.ENABLED) {
                int n = 700;
                try {
                    String string2;
                    Process process = Runtime.getRuntime().exec("logcat -v time -d " + android.os.Process.myPid());
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), Charset.forName("UTF-8")));
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    while ((string2 = bufferedReader.readLine()) != null) {
                        arrayList2.add(string2);
                    }
                    bufferedReader.close();
                    arrayList2.trimToSize();
                    int n2 = 0;
                    if (arrayList2.size() > n) {
                        n2 = arrayList2.size() - n;
                    }
                    for (int i = n2; i < arrayList2.size(); ++i) {
                        if (((String)arrayList2.get(i)).length() <= 18) continue;
                        a a2 = new a();
                        a2.a(((String)arrayList2.get(i)).substring(18));
                        a2.a(a.b(((String)arrayList2.get(i)).substring(0, 18)));
                        arrayList.add(a2);
                    }
                    arrayList2.clear();
                    return arrayList;
                }
                catch (IOException iOException) {
                    InstabugSDKLogger.e(Builder.class, "Could not read logcat log", iOException);
                    return arrayList;
                }
            }
            return arrayList;
        }

        public State build(boolean bl) {
            State state = new State().setSdkVersion(this.getSdkVersion()).setLocale(this.getLocale()).setDuration(this.getActiveSessionDuration()).setDevice(this.getDevice()).setIsDeviceRooted(this.isDeviceRooted()).setOS(this.getOS()).setCarrier(this.getCarrier()).setAppVersion(this.getAppVersion()).setAppPackageName(this.getAppPackageName()).setBatteryLevel(this.getBatteryLevel()).setBatteryState(this.getBatteryState()).setWifiState(this.getWifiState()).setWifiSSID(this.getWifiSSID()).setFreeMemory(this.getFreeMemory()).setUsedMemory(this.getUsedMemory()).setTotalMemory(this.getTotalMemory()).setFreeStorage(this.getFreeStorage()).setUsedStorage(this.getUsedStorage()).setTotalStorage(this.getTotalStorage()).setScreenDensity(this.getScreenDensity()).setScreenSize(this.getScreenSize()).setScreenOrientation(this.getScreenOrientation()).setCurrentView(this.getCurrentView()).setConsoleLog(Builder.getConsoleLog()).setUserSteps(this.getUserSteps()).setUserEmail(this.getUserEmail()).setUserData(this.getUserData()).setReportedAt(this.getReportedAt()).setTags(this.getTags()).setUserAttributes(UserAttributesCacheManager.getUserAttributes()).setNetworkLogs(this.getNetworkLogs()).setUserEvents(this.getUserEvents()).setVisualUserSteps(this.getVisualUserSteps());
            if (bl) {
                state.setInstabugLog(this.getInstabugLog());
            }
            return state;
        }

        public State buildInternalState() {
            return new State().setSdkVersion(this.getSdkVersion()).setLocale(this.getLocale()).setDuration(this.getActiveSessionDuration()).setDevice(this.getDevice()).setIsDeviceRooted(this.isDeviceRooted()).setOS(this.getOS()).setCarrier(this.getCarrier()).setAppVersion(this.getAppVersion()).setAppPackageName(this.getAppPackageName()).setBatteryLevel(this.getBatteryLevel()).setBatteryState(this.getBatteryState()).setWifiState(this.getWifiState()).setWifiSSID(this.getWifiSSID()).setFreeMemory(this.getFreeMemory()).setUsedMemory(this.getUsedMemory()).setTotalMemory(this.getTotalMemory()).setFreeStorage(this.getFreeStorage()).setUsedStorage(this.getUsedStorage()).setTotalStorage(this.getTotalStorage()).setScreenDensity(this.getScreenDensity()).setScreenSize(this.getScreenSize()).setScreenOrientation(this.getScreenOrientation()).setCurrentView(this.getCurrentView()).setReportedAt(this.getReportedAt());
        }

        private String getSdkVersion() {
            return "4.11.0";
        }

        private String getLocale() {
            return this.context.getResources().getConfiguration().locale.toString();
        }

        private long getActiveSessionDuration() {
            return e.a().b();
        }

        public String formatSessionDuration(long l) {
            StringBuilder stringBuilder = new StringBuilder();
            int n = (int)l % 60;
            int n2 = (int)(l /= 60L) % 60;
            int n3 = (int)(l /= 60L) % 60;
            if (n3 <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n3);
            stringBuilder.append(":");
            if (n2 <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n2);
            stringBuilder.append(":");
            if (n <= 9) {
                stringBuilder.append("0");
            }
            stringBuilder.append(n);
            return stringBuilder.toString();
        }

        private String getDevice() {
            return InstabugDeviceProperties.getDeviceType();
        }

        public boolean isDeviceRooted() {
            try {
                if (com.instabug.library.internal.device.a.a()) {
                    return true;
                }
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(this, "Something went wrong while checking if device is rooted or not " + exception.getMessage());
                return false;
            }
            return false;
        }

        private String getOS() {
            return "OS Level " + Build.VERSION.SDK_INT;
        }

        private String getCarrier() {
            try {
                return ((TelephonyManager)this.context.getSystemService("phone")).getNetworkOperatorName();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(this, "Got error while get Carrier", exception);
                return "Unknown";
            }
        }

        private String getAppPackageName() {
            return InstabugDeviceProperties.getPackageName(this.context);
        }

        private String getAppVersion() {
            return InstabugDeviceProperties.getAppVersion(this.context);
        }

        private int getBatteryLevel() {
            try {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                Intent intent = this.context.registerReceiver(null, intentFilter);
                assert (intent != null);
                int n = intent.getIntExtra("level", -1);
                int n2 = intent.getIntExtra("scale", -1);
                float f2 = (float)n / (float)n2;
                return (int)(f2 * 100.0f);
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(this, "Got error while get battery level", exception);
                return -1;
            }
        }

        private String getBatteryState() {
            try {
                boolean bl;
                IntentFilter intentFilter = new IntentFilter("android.intent.action.BATTERY_CHANGED");
                Intent intent = this.context.registerReceiver(null, intentFilter);
                assert (intent != null);
                int n = intent.getIntExtra("status", -1);
                boolean bl2 = n == 2 || n == 5;
                int n2 = intent.getIntExtra("plugged", -1);
                boolean bl3 = n2 == 2;
                boolean bl4 = bl = n2 == 1;
                return bl2 ? "Charging" + (bl ? " through AC Charger" : (bl3 ? " through USB cable" : "")) : "Unplugged";
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(this, "Got error while get battery state", exception);
                return "Unknown";
            }
        }

        private boolean getWifiState() {
            try {
                ConnectivityManager connectivityManager = (ConnectivityManager)this.context.getSystemService("connectivity");
                NetworkInfo networkInfo = connectivityManager.getNetworkInfo(1);
                return networkInfo.isConnected();
            }
            catch (Exception exception) {
                InstabugSDKLogger.e(this, "Got error while get wifi state", exception);
                return false;
            }
        }

        private String getWifiSSID() {
            if (this.getWifiState()) {
                try {
                    WifiManager wifiManager = (WifiManager)this.context.getSystemService("wifi");
                    WifiInfo wifiInfo = wifiManager.getConnectionInfo();
                    return wifiInfo.getSSID();
                }
                catch (SecurityException securityException) {
                    InstabugSDKLogger.e(this, "Could not read wifi SSID. To enable please add the following line in your AndroidManifest.xml <uses-permission android:name=\"android.permission.ACCESS_WIFI_STATE\"/>");
                    return "Connected";
                }
            }
            return "Not Connected";
        }

        private long getFreeMemory() {
            ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            return memoryInfo.availMem / 0x100000L;
        }

        private long getUsedMemory() {
            ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            long l = this.calculateTotalMemory() - memoryInfo.availMem;
            return l / 0x100000L;
        }

        private long getTotalMemory() {
            long l = this.calculateTotalMemory();
            if (l == 0L) {
                InstabugSDKLogger.e(this, "Got error while calculate total memory");
                return -1L;
            }
            return l / 0x100000L;
        }

        private long calculateTotalMemory() {
            if (Build.VERSION.SDK_INT >= 16) {
                return this.calculateTotalMemoryApi16();
            }
            return this.calculateTotalMemoryPreApi16();
        }

        @TargetApi(value=16)
        private long calculateTotalMemoryApi16() {
            ActivityManager activityManager = (ActivityManager)this.context.getSystemService("activity");
            ActivityManager.MemoryInfo memoryInfo = new ActivityManager.MemoryInfo();
            activityManager.getMemoryInfo(memoryInfo);
            return memoryInfo.totalMem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long calculateTotalMemoryPreApi16() {
            RandomAccessFile randomAccessFile = null;
            try {
                randomAccessFile = new RandomAccessFile("/proc/meminfo", "r");
                String string2 = randomAccessFile.readLine();
                String[] stringArray = string2.split(":");
                string2 = stringArray[1].trim();
                string2 = string2.substring(0, string2.length() - 3).trim();
                randomAccessFile.close();
                long l = Long.parseLong(string2) * 1024L;
                return l;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (randomAccessFile != null) {
                    try {
                        randomAccessFile.close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
            return 0L;
        }

        private long getFreeStorage() {
            if (this.externalMemoryAvailable()) {
                long l = Environment.getExternalStorageDirectory().getUsableSpace();
                return l / 0x100000L;
            }
            InstabugSDKLogger.e(this, "Got error while calculate free storage");
            return -1L;
        }

        private long getUsedStorage() {
            if (this.externalMemoryAvailable()) {
                long l = Environment.getExternalStorageDirectory().getTotalSpace() - Environment.getExternalStorageDirectory().getFreeSpace();
                return l / 0x100000L;
            }
            InstabugSDKLogger.e(this, "Got error while calculate used storage");
            return -1L;
        }

        private long getTotalStorage() {
            if (this.externalMemoryAvailable()) {
                long l = Environment.getExternalStorageDirectory().getTotalSpace();
                return (int)(l / 0x100000L);
            }
            InstabugSDKLogger.e(this, "Got error while calculate total storage");
            return -1L;
        }

        private boolean externalMemoryAvailable() {
            return Environment.getExternalStorageState().equals("mounted");
        }

        private String getScreenDensity() {
            DisplayMetrics displayMetrics = this.getDisplayMetrics();
            if (displayMetrics.densityDpi < 160) {
                return "ldpi";
            }
            if (displayMetrics.densityDpi < 240) {
                return "mdpi";
            }
            if (displayMetrics.densityDpi < 320) {
                return "hdpi";
            }
            if (displayMetrics.densityDpi < 480) {
                return "xhdpi";
            }
            if (displayMetrics.densityDpi < 640) {
                return "xxhdpi";
            }
            return "xxxhdpi";
        }

        private String getScreenSize() {
            DisplayMetrics displayMetrics = this.getDisplayMetrics();
            return String.format("%sx%s", displayMetrics.widthPixels, displayMetrics.heightPixels);
        }

        private DisplayMetrics getDisplayMetrics() {
            Display display = ((WindowManager)this.context.getSystemService("window")).getDefaultDisplay();
            DisplayMetrics displayMetrics = new DisplayMetrics();
            display.getMetrics(displayMetrics);
            if (Build.VERSION.SDK_INT >= 17) {
                display.getRealMetrics(displayMetrics);
            }
            return displayMetrics;
        }

        private String getScreenOrientation() {
            if (this.context.getResources().getConfiguration().orientation == 2) {
                return "landscape";
            }
            return "portrait";
        }

        private String getCurrentView() {
            return d.a().b();
        }

        private String getInstabugLog() {
            if (com.instabug.library.b.a().b(Feature.INSTABUG_LOGS) == Feature.State.ENABLED) {
                return InstabugLog.getLogs();
            }
            return null;
        }

        private ArrayList<c> getUserSteps() {
            return d.a().c();
        }

        private ArrayList<com.instabug.library.visualusersteps.b> getVisualUserSteps() {
            return com.instabug.library.visualusersteps.d.a().b();
        }

        private String getUserEmail() {
            return com.instabug.library.user.a.b();
        }

        private String getUserData() {
            return SettingsManager.getInstance().getUserData();
        }

        private long getReportedAt() {
            return InstabugDateFormatter.getCurrentUTCTimeStampInSeconds();
        }

        private String getTags() {
            return SettingsManager.getInstance().getTagsAsString();
        }

        public String getNetworkLogs() {
            com.instabug.library.internal.storage.cache.a.c c2 = com.instabug.library.internal.storage.cache.a.a.a().b();
            String string2 = "_id DESC";
            String string3 = "100";
            JSONArray jSONArray = new JSONArray();
            Cursor cursor = c2.a("network_logs", null, null, null, null, null, "_id DESC", "100");
            if (cursor.moveToFirst()) {
                do {
                    NetworkLog networkLog = new NetworkLog();
                    int n = cursor.getColumnIndex("request");
                    networkLog.setRequest(cursor.getString(n));
                    int n2 = cursor.getColumnIndex("response");
                    networkLog.setResponse(cursor.getString(n2));
                    int n3 = cursor.getColumnIndex("method");
                    networkLog.setMethod(cursor.getString(n3));
                    int n4 = cursor.getColumnIndex("url");
                    networkLog.setUrl(cursor.getString(n4));
                    int n5 = cursor.getColumnIndex("status");
                    networkLog.setResponseCode(cursor.getInt(n5));
                    int n6 = cursor.getColumnIndex("date");
                    networkLog.setDate(cursor.getString(n6));
                    int n7 = cursor.getColumnIndex("headers");
                    networkLog.setHeaders(cursor.getString(n7));
                    int n8 = cursor.getColumnIndex("response_time");
                    networkLog.setTotalDuration(cursor.getInt(n8));
                    try {
                        jSONArray.put((Object)networkLog.toJsonObject());
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
            c2.b();
            return jSONArray.toString();
        }

        private String getUserEvents() {
            try {
                return UserEvent.toJson(InstabugUserEventLogger.getInstance().getUserEvents()).toString();
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(this, "Got error while parsing user events logs", jSONException);
                return "";
            }
        }

        private String getUserAttributes() {
            String string2 = "{}";
            HashMap<String, String> hashMap = UserAttributesCacheManager.getAll();
            if (hashMap != null && hashMap.size() != 0) {
                b b2 = new b();
                b2.a(hashMap);
                try {
                    string2 = b2.toJson();
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e(this, "parsing user attributes got error: " + jSONException.getMessage(), jSONException);
                }
            }
            return string2;
        }
    }

    public static class StateItem<V>
    implements Serializable {
        String key;
        V value;

        public String getKey() {
            return this.key;
        }

        public StateItem<V> setKey(String string2) {
            this.key = string2;
            return this;
        }

        public V getValue() {
            return this.value;
        }

        public StateItem<V> setValue(V v) {
            this.value = v;
            return this;
        }

        public String toString() {
            return "key: " + this.getKey() + ", value: " + this.getValue();
        }
    }
}

