/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import com.instabug.library.internal.storage.cache.CacheChangedListener;
import java.util.ArrayList;
import java.util.List;

public abstract class Cache<K, V> {
    private final List<CacheChangedListener<V>> listeners;
    private String id;
    private int appVersion = -1;

    public Cache(String string2) {
        this(string2, 1);
    }

    protected Cache(String string2, int n) {
        this.id = string2;
        this.appVersion = n;
        this.listeners = new ArrayList<CacheChangedListener<V>>();
    }

    public abstract V get(K var1);

    public abstract V put(K var1, V var2);

    public abstract V delete(K var1);

    public abstract List<V> getValues();

    public abstract long size();

    public void notifyItemRemoved(V v) {
        for (CacheChangedListener<V> cacheChangedListener : this.listeners) {
            cacheChangedListener.onCachedItemRemoved(v);
        }
    }

    public void notifyItemAdded(V v) {
        for (CacheChangedListener<V> cacheChangedListener : this.listeners) {
            cacheChangedListener.onCachedItemAdded(v);
        }
    }

    public void notifyItemUpdated(V v, V v2) {
        for (CacheChangedListener<V> cacheChangedListener : this.listeners) {
            cacheChangedListener.onCachedItemUpdated(v, v2);
        }
    }

    public void notifyCacheInvalidated() {
        for (CacheChangedListener<V> cacheChangedListener : this.listeners) {
            cacheChangedListener.onCacheInvalidated();
        }
    }

    public abstract void invalidate();

    public String getId() {
        return this.id;
    }

    public int getAppVersion() {
        return this.appVersion;
    }

    public boolean addOnCacheChangedListener(CacheChangedListener<V> cacheChangedListener) {
        return !this.listeners.contains(cacheChangedListener) && this.listeners.add(cacheChangedListener);
    }

    public boolean removeOnCacheChangedListener(CacheChangedListener<V> cacheChangedListener) {
        return this.listeners.remove(cacheChangedListener);
    }
}

