/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.storage.cache;

import android.content.Context;
import android.os.Environment;
import com.instabug.library.internal.storage.cache.AssetCache;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.model.AssetEntity;
import com.instabug.library.network.Request;
import com.instabug.library.network.a.b;
import com.instabug.library.util.InstabugSDKLogger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import rx.Subscription;

@SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
public class AssetsCacheManager {
    private static final String ASSETS_MEMORY_CACHE_KEY = "assets_memory_cache";
    private static LinkedHashMap<String, a> currentDownloadingFiles = new LinkedHashMap();

    public static AssetCache getCache() {
        if (!CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache not found, create it");
            CacheManager.getInstance().addCache(new AssetCache(ASSETS_MEMORY_CACHE_KEY));
            InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets created successfully");
        }
        InstabugSDKLogger.d(AssetsCacheManager.class, "In-memory assets cache found");
        return (AssetCache)CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY);
    }

    public static AssetEntity createEmptyEntity(Context context, String string2, AssetEntity.AssetType assetType) {
        File file = new File(AssetsCacheManager.getCashDirectory(context), String.valueOf(string2.hashCode()));
        return new AssetEntity(String.valueOf(string2.hashCode()), assetType, string2, file);
    }

    public static void getAssetEntity(Context context, AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        AssetCache assetCache = AssetsCacheManager.getCache();
        AssetEntity assetEntity2 = assetCache != null ? (AssetEntity)assetCache.get(assetEntity.getKey()) : null;
        if (assetEntity2 != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Get file from cache");
            onDownloadFinished.onSuccess(assetEntity2);
        } else if (AssetsCacheManager.isDownloading(assetEntity.getKey())) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File currently downloading, wait download to finish");
            AssetsCacheManager.waitDownloadToFinish(assetEntity, onDownloadFinished);
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "File not exist download it");
            AssetsCacheManager.downloadAssetEntity(context, assetEntity, onDownloadFinished);
        }
    }

    public static void downloadAssetEntity(Context context, final AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        a a2 = new a();
        a2.a(assetEntity);
        List<OnDownloadFinished> list = a2.c();
        list.add(onDownloadFinished);
        a2.a(list);
        Subscription subscription = b.a().a(context, assetEntity, new Request.Callbacks<AssetEntity, Throwable>(){

            public void a(AssetEntity assetEntity2) {
                AssetsCacheManager.addAssetEntity(assetEntity2);
                AssetsCacheManager.notifyDownloadFinishedSuccessfully(assetEntity2);
            }

            public void a(Throwable throwable) {
                InstabugSDKLogger.e(this, "downloading asset entity got error: ", throwable);
                AssetsCacheManager.notifyDownloadFailed(assetEntity, throwable);
            }

            @Override
            public /* synthetic */ void onFailed(Object object) {
                this.a((Throwable)object);
            }

            @Override
            public /* synthetic */ void onSucceeded(Object object) {
                this.a((AssetEntity)object);
            }
        });
        a2.a(subscription);
        currentDownloadingFiles.put(a2.a().getKey(), a2);
    }

    public static void addAssetEntity(AssetEntity assetEntity) {
        AssetCache assetCache = AssetsCacheManager.getCache();
        if (assetCache != null) {
            assetCache.put(assetEntity.getKey(), assetEntity);
        }
    }

    public static boolean isDownloading(String string2) {
        return currentDownloadingFiles.get(string2) != null;
    }

    public static void waitDownloadToFinish(AssetEntity assetEntity, OnDownloadFinished onDownloadFinished) {
        List<OnDownloadFinished> list = currentDownloadingFiles.get(assetEntity.getKey()).c();
        list.add(onDownloadFinished);
        currentDownloadingFiles.get(assetEntity.getKey()).a(list);
    }

    public static void notifyDownloadFinishedSuccessfully(AssetEntity assetEntity) {
        for (OnDownloadFinished onDownloadFinished : currentDownloadingFiles.get(assetEntity.getKey()).c()) {
            if (onDownloadFinished == null) continue;
            onDownloadFinished.onSuccess(assetEntity);
            currentDownloadingFiles.remove(assetEntity.getKey());
        }
    }

    public static void notifyDownloadFailed(AssetEntity assetEntity, Throwable throwable) {
        for (OnDownloadFinished onDownloadFinished : currentDownloadingFiles.get(assetEntity.getKey()).c()) {
            if (onDownloadFinished == null) continue;
            onDownloadFinished.onFailed(throwable);
            currentDownloadingFiles.remove(assetEntity.getKey());
        }
    }

    public static void stopRunningDownloads() {
        for (Map.Entry<String, a> entry : currentDownloadingFiles.entrySet()) {
            entry.getValue().b().unsubscribe();
        }
        currentDownloadingFiles.clear();
    }

    public static void clearRedundantFiles(Context context) {
        File[] fileArray = AssetsCacheManager.getCashDirectory(context).listFiles();
        if (fileArray == null) {
            return;
        }
        for (File file : fileArray) {
            file.delete();
        }
    }

    public static void cleanUpCache(Context context) {
        Cache cache;
        AssetsCacheManager.stopRunningDownloads();
        if (CacheManager.getInstance().cacheExists(ASSETS_MEMORY_CACHE_KEY) && (cache = CacheManager.getInstance().getCache(ASSETS_MEMORY_CACHE_KEY)) != null) {
            cache.invalidate();
        }
        AssetsCacheManager.clearRedundantFiles(context);
    }

    public static File getCashDirectory(Context context) {
        String string2;
        if (Environment.getExternalStorageState().equals("mounted") && context.getExternalCacheDir() != null) {
            InstabugSDKLogger.d(AssetsCacheManager.class, "Media Mounted");
            string2 = context.getExternalCacheDir().getPath();
        } else {
            InstabugSDKLogger.d(AssetsCacheManager.class, "External storage not available, saving file to internal storage.");
            string2 = context.getCacheDir().getAbsolutePath();
        }
        File file = new File(string2 + "/instabug/assetCache");
        if (!file.exists()) {
            boolean bl = file.mkdirs();
            InstabugSDKLogger.d(AssetsCacheManager.class, "Is created: " + bl);
            File file2 = new File(file, ".nomedia");
            try {
                file2.createNewFile();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return file;
    }

    public static interface OnDownloadFinished {
        public void onSuccess(AssetEntity var1);

        public void onFailed(Throwable var1);
    }

    public static class a {
        public AssetEntity a;
        public Subscription b;
        public List<OnDownloadFinished> c = new ArrayList<OnDownloadFinished>();

        public a a(AssetEntity assetEntity) {
            this.a = assetEntity;
            return this;
        }

        public a a(Subscription subscription) {
            this.b = subscription;
            return this;
        }

        public a a(List<OnDownloadFinished> list) {
            this.c = list;
            return this;
        }

        public AssetEntity a() {
            return this.a;
        }

        public Subscription b() {
            return this.b;
        }

        public List<OnDownloadFinished> c() {
            return this.c;
        }
    }
}

