/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.analytics.model;

import com.instabug.library.util.InstabugDateFormatter;
import com.instabug.library.util.InstabugSDKLogger;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Api {
    private static final String KEY_TIME_STAMP = "time_stamp";
    private static final String KEY_METHOD = "method";
    private static final String KEY_IS_DEPRECATED = "is_deprecated";
    private static final String KEY_PARAMETERS = "parameters";
    private static final String KEY_COUNT = "count";
    private long timeStamp;
    private String apiName;
    private boolean isDeprecated;
    private int count = 1;
    private ArrayList<Parameter> parameters;

    public Api() {
        this.setTimeStamp(InstabugDateFormatter.getCurrentUTCTimeStampInMiliSeconds());
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public Api setTimeStamp(long l) {
        this.timeStamp = l;
        return this;
    }

    public String getApiName() {
        return this.apiName;
    }

    public Api setApiName(String string2) {
        this.apiName = string2;
        return this;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Api setDeprecated(boolean bl) {
        this.isDeprecated = bl;
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.count = n;
    }

    public void incrementCount() {
        ++this.count;
    }

    public ArrayList<Parameter> getParameters() {
        return this.parameters;
    }

    public Api setParameters(ArrayList<Parameter> arrayList) {
        this.parameters = arrayList;
        return this;
    }

    public JSONObject toJson() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put(KEY_TIME_STAMP, this.getTimeStamp()).put(KEY_METHOD, (Object)this.getApiName()).put(KEY_IS_DEPRECATED, this.isDeprecated()).put(KEY_COUNT, this.getCount()).put(KEY_PARAMETERS, (Object)Parameter.toJson(this.getParameters()));
        }
        catch (JSONException jSONException) {
            InstabugSDKLogger.e(Api.class, jSONException.getMessage(), jSONException);
        }
        return jSONObject;
    }

    public static JSONArray toJson(ArrayList<Api> arrayList) {
        JSONArray jSONArray = new JSONArray();
        for (Api api : arrayList) {
            jSONArray.put((Object)api.toJson());
        }
        return jSONArray;
    }

    public static class Parameter {
        private static final String KEY_NAME = "name";
        private static final String KEY_TYPE = "type";
        private static final String KEY_VALUE = "value";
        private String name;
        private String type;
        private String value;

        public String getName() {
            return this.name;
        }

        public Parameter setName(String string2) {
            this.name = string2;
            return this;
        }

        public String getType() {
            return this.type;
        }

        public Parameter setType(Class<?> clazz) {
            this.type = clazz.getSimpleName();
            return this;
        }

        public String getValue() {
            return this.value;
        }

        public Parameter setValue(Object object) {
            this.value = object == null ? "null" : object.toString();
            return this;
        }

        public JSONObject toJson() {
            JSONObject jSONObject = new JSONObject();
            try {
                if (this.getName() != null) {
                    jSONObject.put(KEY_NAME, (Object)this.getName());
                }
                if (this.getType() != null) {
                    jSONObject.put(KEY_TYPE, (Object)this.getType());
                }
                if (this.getValue() != null) {
                    jSONObject.put(KEY_VALUE, (Object)this.getValue());
                }
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
            }
            return jSONObject;
        }

        public static Parameter fromJson(JSONObject jSONObject) {
            Parameter parameter = new Parameter();
            try {
                if (jSONObject.has(KEY_NAME)) {
                    parameter.name = jSONObject.getString(KEY_NAME);
                }
                if (jSONObject.has(KEY_TYPE)) {
                    parameter.type = jSONObject.getString(KEY_TYPE);
                }
                if (jSONObject.has(KEY_VALUE)) {
                    parameter.value = jSONObject.getString(KEY_VALUE);
                }
            }
            catch (JSONException jSONException) {
                InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
            }
            return parameter;
        }

        public static JSONArray toJson(ArrayList<Parameter> arrayList) {
            JSONArray jSONArray = new JSONArray();
            for (Parameter parameter : arrayList) {
                jSONArray.put((Object)parameter.toJson());
            }
            return jSONArray;
        }

        public static ArrayList<Parameter> fromJson(JSONArray jSONArray) {
            ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    arrayList.add(Parameter.fromJson(jSONArray.getJSONObject(i)));
                    continue;
                }
                catch (JSONException jSONException) {
                    InstabugSDKLogger.e(Parameter.class, jSONException.getMessage(), jSONException);
                }
            }
            return arrayList;
        }
    }
}

