/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.internal.video;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Handler;
import com.instabug.library.Instabug;
import com.instabug.library.InstabugState;
import com.instabug.library._InstabugActivity;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.core.eventbus.AutoScreenRecordingEventBus;
import com.instabug.library.core.eventbus.CurrentActivityLifeCycleEventBus;
import com.instabug.library.core.eventbus.SessionStateEventBus;
import com.instabug.library.internal.video.AutoScreenRecordingContract;
import com.instabug.library.internal.video.AutoScreenRecordingFileHolder;
import com.instabug.library.internal.video.AutoScreenRecordingService;
import com.instabug.library.internal.video.RequestPermissionActivity;
import com.instabug.library.model.Session;
import com.instabug.library.settings.SettingsManager;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.tracking.a;
import java.io.File;
import rx.Subscription;
import rx.functions.Action1;

public class InternalAutoScreenRecorderHelper
implements AutoScreenRecordingContract {
    private static InternalAutoScreenRecorderHelper INSTANCE;
    private AutoScreenRecordingFileHolder fileHolder = new AutoScreenRecordingFileHolder();
    private Subscription sessionSubscription;
    private Subscription activityLifeCycleSubscription;
    private boolean isCrashOccurred = false;

    public static InternalAutoScreenRecorderHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new InternalAutoScreenRecorderHelper();
        }
        return INSTANCE;
    }

    public InternalAutoScreenRecorderHelper() {
        this.subscribeToSessionEvents();
        this.subscribeToActivityLifeCycleEvents();
    }

    @Override
    public Uri getAutoScreenRecordingFileUri() {
        return this.fileHolder.getAutoScreenRecordingFileUri();
    }

    public void setAutoScreenRecordingFile(File file) {
        this.fileHolder.setAutoScreenRecordingFile(file);
    }

    @Override
    public void delete() {
        this.fileHolder.delete();
    }

    @Override
    public void clear() {
        this.fileHolder.clear();
    }

    @Override
    public boolean isEnabled() {
        return SettingsManager.getInstance().autoScreenRecordingEnabled();
    }

    public boolean isCrashOccurred() {
        return this.isCrashOccurred;
    }

    public void setCrashOccurred(boolean bl) {
        this.isCrashOccurred = bl;
    }

    private void subscribeToSessionEvents() {
        if (this.sessionSubscription == null || this.sessionSubscription.isUnsubscribed()) {
            this.sessionSubscription = SessionStateEventBus.getInstance().subscribe(new Action1<Session.SessionState>(){

                public void a(Session.SessionState sessionState) {
                    if (sessionState == Session.SessionState.FINISH && !InternalAutoScreenRecorderHelper.this.isCrashOccurred()) {
                        AutoScreenRecordingEventBus.getInstance().post(AutoScreenRecordingService.Action.STOP_DELETE);
                        SettingsManager.getInstance().setAutoScreenRecordingDenied(false);
                        InternalAutoScreenRecorderHelper.this.unsubscribeFromSessionEvents();
                    }
                }

                public /* synthetic */ void call(Object object) {
                    this.a((Session.SessionState)((Object)object));
                }
            });
        }
    }

    private void subscribeToActivityLifeCycleEvents() {
        if (this.activityLifeCycleSubscription == null || this.activityLifeCycleSubscription.isUnsubscribed()) {
            this.activityLifeCycleSubscription = CurrentActivityLifeCycleEventBus.getInstance().subscribe(new Action1<a>(){

                public void a(a a2) {
                    switch (a2) {
                        case c: {
                            InternalAutoScreenRecorderHelper.this.subscribeToSessionEvents();
                            Handler handler = new Handler();
                            handler.postDelayed(new Runnable(){

                                @Override
                                public void run() {
                                    InternalAutoScreenRecorderHelper.getInstance().start();
                                }
                            }, 500L);
                        }
                    }
                }

                public /* synthetic */ void call(Object object) {
                    this.a((a)((Object)object));
                }
            });
        }
    }

    private void unsubscribeFromSessionEvents() {
        if (!this.sessionSubscription.isUnsubscribed()) {
            this.sessionSubscription.unsubscribe();
        }
    }

    public void start() {
        if (SettingsManager.getInstance().isScreenCurrentlyRecorded() || SettingsManager.getInstance().isAutoScreenRecordingDenied() || !this.isEnabled()) {
            return;
        }
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity != null && !(activity instanceof _InstabugActivity) && SettingsManager.getInstance().isAppOnForeground() && Instabug.getState() == InstabugState.ENABLED && !InstabugCore.isForegroundBusy()) {
            Intent intent = new Intent((Context)activity, RequestPermissionActivity.class);
            activity.startActivity(intent);
            activity.overridePendingTransition(0, 0);
        }
    }
}

