/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import com.instabug.library.Instabug;
import com.instabug.library.g.d;
import com.instabug.library.util.InstabugSDKLogger;

public class OrientationUtils {
    private OrientationUtils() {
    }

    public static void unlockOrientation(Activity activity) {
        if (activity != null) {
            InstabugSDKLogger.d(OrientationUtils.class, "Unlocking orientation for activity " + activity.toString());
            ComponentName componentName = new ComponentName((Context)activity, activity.getClass());
            PackageManager packageManager = activity.getPackageManager();
            ActivityInfo activityInfo = null;
            try {
                activityInfo = packageManager.getActivityInfo(componentName, 128);
                activity.setRequestedOrientation(activityInfo.screenOrientation);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                nameNotFoundException.printStackTrace();
                activity.setRequestedOrientation(-1);
            }
            catch (Exception exception) {
                activity.setRequestedOrientation(-1);
            }
        }
    }

    public static void lockScreenOrientation(Activity activity) {
        InstabugSDKLogger.d(OrientationUtils.class, "Locking orientation for activity " + activity.toString());
        switch (activity.getResources().getConfiguration().orientation) {
            case 1: {
                if (Build.VERSION.SDK_INT < 8) {
                    activity.setRequestedOrientation(1);
                    break;
                }
                int n2 = activity.getWindowManager().getDefaultDisplay().getRotation();
                if (n2 == 1 || n2 == 2) {
                    activity.setRequestedOrientation(9);
                    break;
                }
                activity.setRequestedOrientation(1);
                break;
            }
            case 2: {
                if (Build.VERSION.SDK_INT < 8) {
                    activity.setRequestedOrientation(0);
                    break;
                }
                int n3 = activity.getWindowManager().getDefaultDisplay().getRotation();
                if (n3 == 0 || n3 == 1) {
                    activity.setRequestedOrientation(0);
                    break;
                }
                activity.setRequestedOrientation(8);
            }
        }
    }

    public static void handelOrientation(Activity activity) {
        if (d.a().af() == -2) {
            OrientationUtils.lockScreenOrientation(activity);
        } else {
            activity.setRequestedOrientation(Instabug.getRequestedOrientation());
        }
    }

    public static int getOrientation(int n2) {
        switch (n2) {
            case -1: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 4;
            }
            case 5: {
                return 5;
            }
            case 6: {
                return 6;
            }
            case 8: {
                return 8;
            }
            case 9: {
                return 9;
            }
            case 10: {
                return 10;
            }
            case 11: {
                return 11;
            }
            case 12: {
                return 12;
            }
            case 13: {
                return 13;
            }
            case 14: {
                return 14;
            }
        }
        return -1;
    }
}

