/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.messaging.cache;

import android.content.Context;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.instabug.library.internal.storage.AttachmentManager;
import com.instabug.library.internal.storage.cache.AssetsCacheManager;
import com.instabug.library.internal.storage.cache.Cache;
import com.instabug.library.internal.storage.cache.CacheManager;
import com.instabug.library.internal.storage.cache.InMemoryCache;
import com.instabug.library.messaging.model.Chat;
import com.instabug.library.messaging.model.Message;
import com.instabug.library.model.a;
import com.instabug.library.util.InstabugSDKLogger;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ChatsCacheManager {
    public static final String CHATS_DISK_CACHE_KEY = "chats_disk_cache";
    public static final String CHATS_MEMORY_CACHE_KEY = "chats_memory_cache";
    public static final String CHATS_DISK_CACHE_FILE_NAME = "/chats.cache";

    public static InMemoryCache<String, Chat> getCache() throws IllegalArgumentException {
        if (!CacheManager.getInstance().cacheExists(CHATS_MEMORY_CACHE_KEY)) {
            InstabugSDKLogger.d(ChatsCacheManager.class, "In-memory cache not found, loading it from disk " + CacheManager.getInstance().getCache(CHATS_MEMORY_CACHE_KEY));
            CacheManager.getInstance().migrateCache(CHATS_DISK_CACHE_KEY, CHATS_MEMORY_CACHE_KEY, new CacheManager.KeyExtractor<String, Chat>(){

                public String a(Chat chat) {
                    return chat.a();
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Chat)object);
                }
            });
            Cache cache = CacheManager.getInstance().getCache(CHATS_MEMORY_CACHE_KEY);
            if (cache != null) {
                InstabugSDKLogger.d(ChatsCacheManager.class, "In-memory cache restored from disk, " + cache.getValues().size() + " elements restored");
            }
        }
        InstabugSDKLogger.d(ChatsCacheManager.class, "In-memory cache found");
        return (InMemoryCache)CacheManager.getInstance().getCache(CHATS_MEMORY_CACHE_KEY);
    }

    public static void saveCacheToDisk() throws IllegalArgumentException {
        Cache cache = CacheManager.getInstance().getCache(CHATS_MEMORY_CACHE_KEY);
        Cache cache2 = CacheManager.getInstance().getCache(CHATS_DISK_CACHE_KEY);
        if (cache != null) {
            InstabugSDKLogger.d(ChatsCacheManager.class, "Saving In-memory cache to disk, no. of items to save is " + cache.size());
            CacheManager.getInstance().migrateCache(CHATS_MEMORY_CACHE_KEY, CHATS_DISK_CACHE_KEY, new CacheManager.KeyExtractor<String, Chat>(){

                public String a(Chat chat) {
                    return chat.a();
                }

                @Override
                public /* synthetic */ Object extractKey(Object object) {
                    return this.a((Chat)object);
                }
            });
        }
        if (cache2 != null) {
            InstabugSDKLogger.d(ChatsCacheManager.class, "In-memory cache had been persisted on-disk, " + cache2.getValues().size() + " elements saved");
        }
    }

    public static String addOfflineChat(Context context) {
        Chat chat = new Chat.b().a(context);
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            inMemoryCache.put(chat.a(), chat);
        }
        return chat.a();
    }

    @Nullable
    public static Chat getChat(String string2) {
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Chat> list = inMemoryCache.getValues();
            for (Chat chat : list) {
                if (!chat.a().equals(string2)) continue;
                return chat;
            }
        }
        InstabugSDKLogger.e(ChatsCacheManager.class, "No chat with id: " + string2 + " found, returning null");
        return null;
    }

    public static List<Chat> getValidChats() {
        ArrayList<Chat> arrayList = new ArrayList<Chat>();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Chat> list = inMemoryCache.getValues();
            for (Chat chat : list) {
                if (chat.b().size() == 0) continue;
                arrayList.add(chat);
            }
        }
        return arrayList;
    }

    public static List<Chat> getOfflineChats() {
        ArrayList<Chat> arrayList = new ArrayList<Chat>();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Chat> list = inMemoryCache.getValues();
            for (Chat chat : list) {
                if (!chat.c().equals((Object)Chat.ChatState.READY_TO_BE_SENT) && (!chat.c().equals((Object)Chat.ChatState.LOGS_READY_TO_BE_UPLOADED) || chat.b().size() <= 0)) continue;
                arrayList.add(chat);
            }
        }
        return arrayList;
    }

    public static void updateLocalMessageWithSyncedMessage(@NonNull Context context, @NonNull Message message) throws IOException {
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            Chat chat = inMemoryCache.get(message.b());
            ArrayList<Message> arrayList = chat.b();
            for (int i2 = 0; i2 < arrayList.size(); ++i2) {
                if (((Message)arrayList.get(i2)).f() != message.f() || !((Message)arrayList.get(i2)).a().equals(message.a()) || !((Message)arrayList.get(i2)).i().equals((Object)Message.MessageState.READY_TO_BE_SYNCED) || ((Message)arrayList.get(i2)).j().size() != message.j().size()) continue;
                for (int i3 = 0; i3 < ((Message)arrayList.get(i2)).j().size(); ++i3) {
                    a a2;
                    switch (message.j().get(i3).getType()) {
                        case IMAGE: {
                            a2 = AssetsCacheManager.createEmptyEntity(context, message.j().get(i3).getUrl(), a.a.a);
                            break;
                        }
                        case AUDIO: {
                            a2 = AssetsCacheManager.createEmptyEntity(context, message.j().get(i3).getUrl(), a.a.b);
                            break;
                        }
                        case VIDEO: {
                            a2 = AssetsCacheManager.createEmptyEntity(context, message.j().get(i3).getUrl(), a.a.c);
                            break;
                        }
                        default: {
                            a2 = AssetsCacheManager.createEmptyEntity(context, message.j().get(i3).getUrl(), a.a.a);
                        }
                    }
                    File file = new File(((Message)arrayList.get(i2)).j().get(i3).getLocalPath());
                    AttachmentManager.copyFromUriIntoFile(context, Uri.fromFile((File)file), a2.c());
                    AssetsCacheManager.addAssetEntity(a2);
                    boolean bl = file.delete();
                    InstabugSDKLogger.v(ChatsCacheManager.class, "local attachment file deleted: " + bl);
                }
                chat.b().set(i2, message);
                InstabugSDKLogger.v(ChatsCacheManager.class, "messages number: " + chat.b().size());
                InstabugSDKLogger.v(ChatsCacheManager.class, "messages: " + chat.b().get(i2));
                inMemoryCache.put(chat.a(), chat);
                break;
            }
        }
    }

    public static int getTotalMessagesCount() {
        int n2 = 0;
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Chat> list = inMemoryCache.getValues();
            for (Chat chat : list) {
                for (Message message : chat.b()) {
                    if (!message.i().equals((Object)Message.MessageState.SYNCED)) continue;
                    ++n2;
                }
            }
        }
        return n2;
    }

    public static List<Message> getOfflineMessages() {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Chat> list = inMemoryCache.getValues();
            for (Chat chat : list) {
                if (!chat.c().equals((Object)Chat.ChatState.SENT)) continue;
                for (Message message : chat.b()) {
                    if (!message.i().equals((Object)Message.MessageState.READY_TO_BE_SENT) && !message.i().equals((Object)Message.MessageState.SENT)) continue;
                    arrayList.add(message);
                }
            }
        }
        return arrayList;
    }

    public static long getLastMessageMessagedAt() {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Chat> list = inMemoryCache.getValues();
            for (Chat chat : list) {
                for (Message message : chat.b()) {
                    if (message.i() != Message.MessageState.SYNCED) continue;
                    arrayList.add(message);
                }
            }
        }
        Collections.sort(arrayList, new Message.a());
        for (int i2 = arrayList.size() - 1; i2 >= 0; --i2) {
            Message message = (Message)arrayList.get(i2);
            if (message.a().equals("0")) continue;
            return message.f();
        }
        return 0L;
    }

    public static int getUnreadCount() {
        int n2 = 0;
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Chat> list = inMemoryCache.getValues();
            for (Chat chat : list) {
                n2 += chat.d();
            }
        }
        return n2;
    }

    public static List<Message> getNotSentMessages() {
        ArrayList<Message> arrayList = new ArrayList<Message>();
        InMemoryCache<String, Chat> inMemoryCache = ChatsCacheManager.getCache();
        if (inMemoryCache != null) {
            List<Chat> list = inMemoryCache.getValues();
            for (Chat chat : list) {
                for (Message message : chat.b()) {
                    if (message.i() != Message.MessageState.SENT && message.i() != Message.MessageState.READY_TO_BE_SENT) continue;
                    arrayList.add(message);
                }
            }
        }
        InstabugSDKLogger.v(ChatsCacheManager.class, "not sent messages count: " + arrayList.size());
        return arrayList;
    }
}

