/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.util.threading;

import android.os.Looper;
import androidx.annotation.Nullable;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.threading.l;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ThreadUtils {
    public static boolean isCurrentThreadMain() {
        return Looper.myLooper() == Looper.getMainLooper();
    }

    private static String getMainThreadStackTrace(String errorName) {
        String string2;
        return ThreadUtils.buildStackTraceFromElements(Looper.getMainLooper().getThread().getStackTrace(), string2);
    }

    /*
     * WARNING - void declaration
     */
    public static String buildStackTraceFromElements(StackTraceElement[] stackTraceElements, @Nullable String errorName) {
        StackTraceElement[] stackTraceElementArray;
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        if (errorName != null) {
            void var1_1;
            stringBuilder2.append((String)var1_1).append("\n");
        }
        int n2 = stackTraceElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            StringBuilder stringBuilder3 = stringBuilder2;
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            stringBuilder3.append("\t at ");
            stringBuilder3.append(stackTraceElement.toString());
            stringBuilder3.append("\n");
        }
        return stringBuilder2.toString();
    }

    public static JSONObject getMainThreadData(@Nullable String errorName) throws JSONException {
        String string2;
        JSONObject jSONObject = ThreadUtils.getThreadData(Looper.getMainLooper().getThread());
        jSONObject.put("error", (Object)ThreadUtils.getStackTraceAsError(Looper.getMainLooper().getThread(), string2));
        return jSONObject;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JSONObject getStackTraceAsError(Thread thread, @Nullable String errorName) {
        JSONException jSONException2;
        Object object;
        String string2;
        JSONObject jSONObject;
        block11: {
            String string3;
            block10: {
                block9: {
                    JSONObject jSONObject2;
                    jSONObject = jSONObject2;
                    jSONObject2 = new JSONObject();
                    if (errorName != null) {
                        JSONObject jSONObject3 = jSONObject;
                        JSONObject jSONObject4 = jSONObject3;
                        jSONObject3.put("name", (Object)"ANRError: Application Not Responding for at least 5000 ms.\n");
                        jSONObject4.put("exception", (Object)string2);
                    }
                    Thread thread2 = string3;
                    object = null;
                    try {
                        thread2.getStackTrace();
                    }
                    catch (JSONException jSONException2) {}
                    if (thread2.getStackTrace().length > 0) {
                        object = ((Thread)((Object)string3)).getStackTrace()[0];
                    }
                    if (object == null || ((StackTraceElement)object).getFileName() == null) break block9;
                    JSONObject jSONObject5 = jSONObject;
                    String string4 = "location";
                    jSONObject5.put(string4, (Object)(((StackTraceElement)object).getFileName() + ":" + ((StackTraceElement)object).getLineNumber()));
                }
                if (string2 != null) break block10;
                string2 = "";
                break block11;
            }
            string3 = "stackTrace";
            jSONObject.put(string3, (Object)ThreadUtils.getMainThreadStackTrace(string2));
            return jSONObject;
        }
        string2 = "IBG-Core";
        object = jSONException2.getMessage() != null ? jSONException2.getMessage() : "Json exception while creating formatted exception";
        InstabugSDKLogger.e(string2, (String)object, jSONException2);
        return jSONObject;
    }

    public static JSONObject getThreadData(Thread thread) throws JSONException {
        ThreadGroup threadGroup;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2;
        jSONObject2 = new JSONObject();
        JSONObject jSONObject4 = jSONObject;
        jSONObject4();
        jSONObject4.put("threadName", (Object)((Thread)((Object)threadGroup)).getName());
        long l2 = ((Thread)((Object)threadGroup)).getId();
        jSONObject4.put("threadId", l2);
        jSONObject4.put("threadPriority", ((Thread)((Object)threadGroup)).getPriority());
        jSONObject.put("threadState", (Object)((Object)((Object)((Thread)((Object)threadGroup)).getState())).toString());
        threadGroup = thread.getThreadGroup();
        if (threadGroup != null) {
            JSONObject jSONObject5;
            JSONObject jSONObject6 = jSONObject5;
            jSONObject6();
            jSONObject6.put("name", (Object)threadGroup.getName());
            jSONObject6.put("maxPriority", threadGroup.getMaxPriority());
            jSONObject5.put("activeCount", threadGroup.activeCount());
            jSONObject4.put("threadGroup", (Object)jSONObject6);
        }
        JSONObject jSONObject7 = jSONObject3;
        jSONObject7.put("thread", (Object)jSONObject4);
        return jSONObject7;
    }

    private static boolean isMainThread(Thread thread) {
        Thread thread2;
        return Looper.getMainLooper() != null && thread2 == Looper.getMainLooper().getThread();
    }

    public static JSONArray getThreadsData(@Nullable Thread crashingThread) throws JSONException {
        JSONArray jSONArray;
        JSONArray jSONArray2 = jSONArray;
        jSONArray = new JSONArray();
        for (Thread thread : l.a().keySet()) {
            Thread thread2;
            Thread thread3 = thread;
            JSONObject jSONObject = ThreadUtils.getThreadData(thread3);
            ((JSONObject)jSONObject.get("thread")).put("isMain", ThreadUtils.isMainThread(thread3));
            ((JSONObject)jSONObject.get("thread")).put("stackTrace", (Object)ThreadUtils.getStackTraceFromThread(thread3));
            thread3 = (JSONObject)jSONObject.get("thread");
            String string2 = "isCrashing";
            boolean bl = thread == thread2;
            thread3.put(string2, bl);
            jSONArray2.put((Object)jSONObject);
        }
        return jSONArray2;
    }

    public static String getStackTraceFromThread(Thread thread) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder();
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        int n2 = stackTraceElementArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Object object = stringBuilder2;
            StackTraceElement stackTraceElement = stackTraceElementArray[i2];
            ((StringBuilder)object).append("\t at ");
            ((StringBuilder)object).append(stackTraceElement.toString());
            ((StringBuilder)object).append("\n");
        }
        return stringBuilder2.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static JSONObject getThreadDataAndStackTrace(Thread thread, Throwable throwable) throws JSONException {
        void var1_2;
        Thread thread2;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3 = jSONObject2 = jSONObject;
        jSONObject3();
        jSONObject3.put("crashed", true);
        long l2 = thread2.getId();
        jSONObject2.put("threadId", l2);
        jSONObject2.put("isMain", ThreadUtils.isMainThread(thread2));
        jSONObject.put("stackTrace", (Object)var1_2.getStackTrace());
        return jSONObject;
    }

    public static StackTraceElement[] getCurrentThreadStackTrace() {
        return Thread.currentThread().getStackTrace();
    }
}

