/*
 * Decompiled with CFR 0.152.
 */
package com.instabug.library.core;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.widget.Toast;
import androidx.annotation.NonNull;
import com.instabug.library.Instabug;
import com.instabug.library.R;
import com.instabug.library.core.InstabugCore;
import com.instabug.library.internal.servicelocator.CoreServiceLocator;
import com.instabug.library.screenshot.ScreenshotCaptor;
import com.instabug.library.screenshot.instacapture.ScreenshotRequest;
import com.instabug.library.screenshot.instacapture.q;
import com.instabug.library.tracking.InstabugInternalTrackingDelegate;
import com.instabug.library.util.BitmapUtils;
import com.instabug.library.util.InstabugSDKLogger;
import com.instabug.library.util.LocaleUtils;
import com.instabug.library.util.memory.MemoryUtils;

public class InitialScreenshotHelper {
    public static void captureScreenshot(@NonNull InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        Throwable throwable;
        InstabugSDKLogger.d("IBG-Core", "[InitialScreenshotHelper#captureScreenshot] Starting in screenshot capturing process");
        Activity activity = InstabugInternalTrackingDelegate.getInstance().getTargetActivity();
        if (activity == null) {
            Throwable throwable2;
            InitialScreenshotCapturingListener initialScreenshotCapturingListener = throwable;
            InstabugSDKLogger.d("IBG-Core", "[InitialScreenshotHelper#captureScreenshot] No target activity found");
            throwable = throwable2;
            throwable2 = new Throwable("Target Activity not found");
            initialScreenshotCapturingListener.onScreenshotCapturingFailed(throwable);
            return;
        }
        if (MemoryUtils.isLowMemory((Context)activity)) {
            Activity activity2 = activity;
            InstabugSDKLogger.e("IBG-Core", "Couldn't take initial screenshot due to low memory");
            throwable.onScreenshotCapturingFailed(new Throwable("Your activity is currently in low memory"));
            Toast.makeText((Context)activity2, (CharSequence)LocaleUtils.getLocaleStringResource(InstabugCore.getLocale((Context)activity2), R.string.instabug_str_capturing_screenshot_error, (Context)activity), (int)0).show();
            return;
        }
        CoreServiceLocator.getScreenshotCaptor().capture(InitialScreenshotHelper.createInitialScreenshotRequest((InitialScreenshotCapturingListener)((Object)throwable), activity));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private static ScreenshotRequest createInitialScreenshotRequest(@NonNull InitialScreenshotCapturingListener initialScreenshotCapturingListenr, Activity activity) {
        void var1_1;
        ScreenshotCaptor.CapturingCallback capturingCallback;
        capturingCallback = InitialScreenshotHelper.createCapturingListener((InitialScreenshotCapturingListener)((Object)capturingCallback), (Activity)var1_1);
        return ScreenshotRequest.createScreenshotRequest(new q(0, (Activity)var1_1, capturingCallback));
    }

    /*
     * WARNING - void declaration
     */
    @NonNull
    private static ScreenshotCaptor.CapturingCallback createCapturingListener(@NonNull InitialScreenshotCapturingListener initialScreenshotCapturingListenr, Activity activity) {
        InitialScreenshotCapturingListener initialScreenshotCapturingListener;
        void var1_1;
        return new ScreenshotCaptor.CapturingCallback((Activity)var1_1, initialScreenshotCapturingListener){
            final /* synthetic */ Activity a;
            final /* synthetic */ InitialScreenshotCapturingListener b;
            {
                this.a = activity;
                this.b = initialScreenshotCapturingListener;
            }

            @Override
            public void onCapturingSuccess(Bitmap bitmap) {
                a a2 = a3;
                InstabugSDKLogger.d("IBG-Core", "[InitialScreenshotHelper#createCapturingListener] Capturing succeeded.");
                a a3 = a2.a;
                InitialScreenshotHelper.access$000(bitmap, (Activity)a3, a2.b);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onCapturingFailure(Throwable throwable) {
                void var1_1;
                InstabugSDKLogger.e("IBG-Core", "initial screenshot capturing got error: " + var1_1.getMessage());
                this.b.onScreenshotCapturingFailed((Throwable)var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static void saveBitmap(Bitmap bitmap, Activity activity, InitialScreenshotCapturingListener initialScreenshotCapturingListenr) {
        if (Instabug.getApplicationContext() != null) {
            void var1_1;
            void var2_2;
            BitmapUtils.OnSaveBitmapCallback onSaveBitmapCallback;
            Object object;
            Bitmap bitmap2 = object;
            object = onSaveBitmapCallback;
            onSaveBitmapCallback = new BitmapUtils.OnSaveBitmapCallback((InitialScreenshotCapturingListener)var2_2){
                final /* synthetic */ InitialScreenshotCapturingListener a;
                {
                    this.a = initialScreenshotCapturingListener;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onSuccess(Uri screenshotUri) {
                    void var1_1;
                    InstabugSDKLogger.d("IBG-Core", "[InitialScreenshotHelper#saveBitmap] Saving bitmap succeeded.");
                    this.a.onScreenshotCapturedSuccessfully((Uri)var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void onError(Throwable throwable) {
                    void var1_1;
                    InstabugSDKLogger.e("IBG-Core", "initial screenshot capturing got error: " + var1_1.getMessage());
                    this.a.onScreenshotCapturingFailed((Throwable)var1_1);
                }
            };
            BitmapUtils.saveBitmap(bitmap2, (Context)var1_1, (BitmapUtils.OnSaveBitmapCallback)object);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(Bitmap x02, Activity x12, InitialScreenshotCapturingListener x2) {
        void var2_2;
        void var1_1;
        InitialScreenshotHelper.saveBitmap(x02, (Activity)var1_1, (InitialScreenshotCapturingListener)var2_2);
    }

    public static interface InitialScreenshotCapturingListener {
        public void onScreenshotCapturedSuccessfully(Uri var1);

        public void onScreenshotCapturingFailed(Throwable var1);
    }
}

