package com.instabug.library.visualusersteps.manual.configuration

import com.instabug.library.featuresflags.configs.FeatureFlagsConfigsHandler
import org.json.JSONObject

class ManualUserStepsConfigurationHandler(
    private val configurationProvider: ManualUserStepsConfigurationProvider
) : FeatureFlagsConfigsHandler {

    override fun handleConfigs(featuresResponse: JSONObject) {
        val featureEnabled = featuresResponse.optBoolean(
            JSON_KEY_MANUAL_USER_STEPS_BE_ENABLED,
            DEFAULT_MANUAL_USER_STEPS_BE_ENABLED
        )
        configurationProvider.enabled = featureEnabled
    }
}
