package com.instabug.library.util.threading

import java.util.concurrent.Callable
import java.util.concurrent.ExecutorService
import java.util.concurrent.Future

class OrderedExecutor(
    private val key: String,
    private val delegate: OrderedExecutorService
) : ExecutorService by delegate {

    override fun execute(command: Runnable) {
        delegate.execute(key, command)
    }

    override fun <V> submit(task: Callable<V>): Future<V> =
        delegate.submit(key, task)
}
