package com.instabug.library.util.overairversion

import com.instabug.library.factory.ParameterizedFactory
import com.instabug.library.util.overairversion.OverAirVersionType.CODE_PUSH
import com.instabug.library.util.overairversion.OverAirVersionType.EXPO

interface OnAirVersionTypeHandler {
    fun handleVersion(version: String?, @OverAirVersionType.Type type: Int, isSetByUser: Boolean?)
    fun sanitize(version: String): String
}

class OnAirVersionTypeHandlerFactory :
    ParameterizedFactory<OnAirVersionTypeHandler, @OverAirVersionType.Type Int> {
    override fun create(@OverAirVersionType.Type type: Int): OnAirVersionTypeHandler {
        return when (type) {
            CODE_PUSH -> CodePushVersionHandler
            EXPO -> ExpoVersionHandler
            else -> throw IllegalArgumentException("Unknown OverAirVersionType: $type")
        }
    }
}
