package com.instabug.library.util.filters.actions;

/**
 * A functional interface similar to {@link Runnable} that allows passing and returning a consumable
 * element
 *
 * @param <T> type of the consumable element
 */
@FunctionalInterface
public interface ReturnableAction<T, N> {

    /**
     * Runs the action and optionally consumes the passed element {@code t} and return it
     *
     * @param t the element to be consumed
     * @return the consumed element
     */
    N apply(T t);
}
