package com.instabug.library.util.extenstions

import org.json.JSONArray
import org.json.JSONObject


val List<String>.toJsonArray
    get() = JSONArray(this)

fun Map<String, Any?>.toJsonObject(): JSONObject {
    val jsonObject = JSONObject()
    for (item in this) {
        jsonObject.put(item.key, item.value)
    }
    return jsonObject
}

fun JSONObject.toMap(): MutableMap<String, Any?> {
    val map = mutableMapOf<String, Any?>()
    for (key in this.keys()) {
        map[key] = this.get(key)
    }
    return map
}

fun JSONArray.toMutableStringSet(): MutableSet<String> = buildSet {
    for (index in 0 until length()) add(getString(index))
}.toMutableSet()


operator fun JSONArray?.plus(other: JSONArray?) =
    if (!(this == null && other == null)) {
        JSONArray().also {
            it += this
            it += other
        }
    } else {
        null
    }

operator fun JSONArray.plusAssign(other: JSONArray?) {
    other?.let { otherArray ->
        for (index in 0 until otherArray.length()) {
            put(otherArray[index])
        }
    }
}

fun JSONObject.optNullableString(key: String): String? =
    optString(key).takeIf { it.isNotEmpty() }