package com.instabug.library.util

import java.util.concurrent.Future
import java.util.concurrent.ScheduledExecutorService
import java.util.concurrent.TimeUnit
import java.util.concurrent.atomic.AtomicReference

fun interface Job<T> {
    operator fun invoke(param: T)
}

interface JobThrottler<T> {
    operator fun invoke(job: Job<T>, param: T, interval: Long)
}

class LatestJobThrottler<T>(
    private val scheduler: ScheduledExecutorService
) : JobThrottler<T> {

    private var throttleJob: Future<*>? = null
    private var jobParam: AtomicReference<T?> = AtomicReference<T?>(null)

    override fun invoke(job: Job<T>, param: T, interval: Long) {
        jobParam.set(param)
        throttleJob?.takeUnless { tJob -> tJob.isDone } ?: scheduleJobExecution(job, interval)
    }

    private fun scheduleJobExecution(job: Job<T>, interval: Long) {
        throttleJob = Runnable {
            jobParam.get()?.let(job::invoke)
            throttleJob = null
        }.let { scheduler.schedule(it, interval, TimeUnit.MILLISECONDS) }
    }
}