package com.instabug.library.util

class CoolDownThrottle(
    private val coolDownPeriodMillis: Long
) {
    private var lastInvocationTimeStampMillis: Long = 0L

    fun validateCoolDownPeriodHasPassed() =
        TimeUtils.currentTimeMillis().takeIf { it.isTimeStampValid() }
            ?.also { lastInvocationTimeStampMillis = it }
            ?.let { true }
            ?: false

    private fun Long.isTimeStampValid() = this - lastInvocationTimeStampMillis > coolDownPeriodMillis

    inline fun <T> invoke(invocation: () -> T, onCoolDown: (() -> Unit) = { }): T? =
        takeIf { validateCoolDownPeriodHasPassed() }?.let { invocation.invoke() }
            ?: let { onCoolDown.invoke() }.let { null }
}

