package com.instabug.library.user;

import android.annotation.SuppressLint;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;


public class UserEvent {

    private static final String EVENT = "event";
    private static final String TIMESTAMP = "timestamp";
    private static final String PARAMS = "params";

    @Nullable
    private String eventIdentifier;
    private long date;
    @NonNull
    private final List<UserEventParam> params;

    public UserEvent() {
        params = new ArrayList<>();
    }

    @Nullable
    public String getEventIdentifier() {
        return eventIdentifier;
    }

    public UserEvent setEventIdentifier(String eventIdentifier) {
        this.eventIdentifier = eventIdentifier;
        return this;
    }

    public long getDate() {
        return date;
    }

    public UserEvent setDate(long date) {
        this.date = date;
        return this;
    }

    @NonNull
    public List<UserEventParam> getParams() {
        return params;
    }

    public UserEvent addParam(UserEventParam userEventParam) {
        params.add(userEventParam);
        return this;
    }

    @SuppressLint("ERADICATE_PARAMETER_NOT_NULLABLE")
    public JSONObject toJson() throws JSONException {
        JSONObject eventJsonObject = new JSONObject();
        eventJsonObject.put(EVENT, getEventIdentifier());
        eventJsonObject.put(TIMESTAMP, getDate());
        JSONObject eventParamsJsonObject = new JSONObject();
        for (UserEventParam userEventParam : getParams()) {
            if (userEventParam != null && userEventParam.getKey() != null)
                eventParamsJsonObject.put(userEventParam.getKey(), userEventParam.getValue());
        }
        eventJsonObject.put(PARAMS, eventParamsJsonObject);
        return eventJsonObject;
    }

    public static JSONArray toJson(List<UserEvent> userEvents) throws JSONException {
        JSONArray jsonArray = new JSONArray();
        for (UserEvent userEvent : userEvents) {
            jsonArray.put(userEvent.toJson());
        }
        return jsonArray;
    }

    @NonNull
    public static JSONArray keysAsJsonArray(@NonNull List<UserEvent> userEvents) {
        Set<String> uniqueKeys = new LinkedHashSet<>();
        for (UserEvent userEvent : userEvents) {
            if (userEvent.getEventIdentifier() != null) {
                uniqueKeys.add(userEvent.getEventIdentifier());
            }
        }
        JSONArray jsonArray = new JSONArray();
        for (String uniqueKey : uniqueKeys) {
            jsonArray.put(uniqueKey);
        }
        return jsonArray;
    }

    @Override
    @SuppressLint("NP_METHOD_PARAMETER_TIGHTENS_ANNOTATION")
    public boolean equals(@Nullable Object userEvent) {
        if (userEvent == null) return false;

        if (userEvent instanceof UserEvent) {
            UserEvent comparedUserEvent = (UserEvent) userEvent;
            if (String.valueOf(comparedUserEvent.getEventIdentifier()).equals(String.valueOf(getEventIdentifier()))
                    && (String.valueOf(comparedUserEvent.getDate()).equals((String.valueOf(getDate()))))) {
                if (comparedUserEvent.getParams().size() == getParams().size()) {
                    for (int i = 0; i < params.size(); i++) {
                        if (!comparedUserEvent.getParams().get(i).equals(getParams().get(i)))
                            return false;
                    }
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    @Override
    public int hashCode() {
        if (getEventIdentifier() != null)
            return (getDate() + ": " + getEventIdentifier()).hashCode();
        else
            return -1;
    }
}
