package com.instabug.library.tracking

import android.app.Application
import com.instabug.library.Feature
import com.instabug.library.IBGFeature
import com.instabug.library.Instabug
import com.instabug.library.SessionManager
import com.instabug.library.core.InstabugCore
import com.instabug.library.core.eventbus.AppStateEvent
import com.instabug.library.core.eventbus.AppStateEventBus
import com.instabug.library.core.eventbus.SessionStateEventBus
import com.instabug.library.internal.servicelocator.CoreServiceLocator
import com.instabug.library.model.session.SessionState
import com.instabug.library.model.v3Session.SessionEvent
import com.instabug.library.sessionV3.manager.IBGSessionManager
import com.instabug.library.util.threading.PoolProvider

class ScreenOffHandler {

    private val screenOffEventMonitor: ScreenOffEventMonitor? by lazy {
        when (val appContext = Instabug.getApplicationContext()) {
            null -> null
            else -> CoreServiceLocator.getScreenOffEventMonitor(appContext as Application)
        }
    }
    private val screenOffEventListener: ScreenOffEventListener by lazy {
        ScreenOffEventListener {
            val backgroundEvent = AppStateEvent.BackgroundAppStateEvent()
            PoolProvider.postIOTask {
                SessionManager.getInstance().finishSession()
                IBGSessionManager emit SessionEvent.End()
                AppStateEventBus emit  backgroundEvent
            }
        }
    }

    init {
        SessionStateEventBus.getInstance().subscribe {
            if (it == SessionState.FINISH) {
                screenOffEventMonitor?.unRegisterListener()
            }
        }
    }

    fun onActivityStarted() {
        PoolProvider.postIOTask {
            if (InstabugCore.getFeatureState(IBGFeature.SCREEN_OFF_MONITOR) == Feature.State.ENABLED)
                screenOffEventMonitor?.registerListener(screenOffEventListener)
        }
    }
}