package com.instabug.library.tracking;

import androidx.annotation.NonNull;

public class CurrentViewProvider {
    private static CurrentViewProvider INSTANCE;
    private String currentActivityView = "";
    private String currentFragmentView = "";
    private String currentCrossPlatformView = "";

    private CurrentViewProvider() {
    }

    public static CurrentViewProvider getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CurrentViewProvider();
        }
        return INSTANCE;
    }

    @NonNull
    public synchronized String getCurrentActivityView() {
        return currentActivityView;
    }

    public synchronized void setCurrentActivityView(@NonNull String currentView) {
        this.currentActivityView = currentView;
    }


    public synchronized String getCurrentFragmentView() {
        if(currentFragmentView != null) {
            if(!currentFragmentView.isEmpty()) {
                return currentFragmentView;
            }
        }

        return currentActivityView;
    }

    public void setCurrentFragmentView(@NonNull String currentFragmentView) {
        this.currentFragmentView = currentFragmentView;
    }

    @NonNull
    public synchronized String getCrossPlatformCurrentView() {
        return currentCrossPlatformView;
    }

    public synchronized void setCrossPlatformCurrentView(@NonNull String currentCrossPlatformView) {
        this.currentCrossPlatformView = currentCrossPlatformView;
    }
}
