package com.instabug.library.sessionreplay.networkLog

import com.instabug.library.diagnostics.IBGDiagnostics
import com.instabug.library.logscollection.LogReceiver
import com.instabug.library.map.Mapper
import com.instabug.library.networkinterception.dispatch.NetworkLogReceiver
import com.instabug.library.networkinterception.model.NetworkClient
import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.sessionreplay.model.SRLog
import com.instabug.library.util.extenstions.runOrLogError
import org.json.JSONObject

class SRNetworkLogReceiver(
    private val srLogReceiver: LogReceiver<SRLog>,
    private val mapper: Mapper<NetworkLogModel, JSONObject?>
) : NetworkLogReceiver {

    override fun onNetworkRequestStarted(reference: Any) {
        // not used by SR
    }

    override fun onNetworkLogCreated(reference: Any, model: NetworkLogModel) {
        runOrLogError("Failed to dispatch network log to Session replay") {
            srLogReceiver.invoke(SRNetworkLog(model, mapper))
            model.reportAsEvent()
        }
    }

    private fun NetworkLogModel.reportAsEvent() {
        when(clientId) {
            NetworkClient.URL_CONNECTION -> URLCONNECTION_EVENT
            NetworkClient.OKHTTP -> OKHTTP_EVENT
            NetworkClient.OkHTTP_GQL -> OKHTTP_EVENT
            else -> OTHER_EVENT
        }.also { IBGDiagnostics.logEvent(it) }
    }

    companion object {
        private const val OKHTTP_EVENT = "sr_store_received_okhttp"
        private const val URLCONNECTION_EVENT = "sr_store_received_urlconnection"
        private const val OTHER_EVENT = "sr_store_received_other_network_client"
    }
}
