package com.instabug.library.sessionreplay.networkLog

import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.networkinterception.model.map.CoreCommonNetworkLogJsonMapper
import com.instabug.library.sessionreplay.LOG_TYPE_KEY
import com.instabug.library.sessionreplay.TIMESTAMP_KEY
import com.instabug.library.sessionreplay.model.SRLogType
import org.json.JSONObject

class SRNetworkLogJsonMapper : CoreCommonNetworkLogJsonMapper() {

    override fun mapToJson(from: NetworkLogModel): JSONObject = super.mapToJson(from).apply {
        put(LOG_TYPE_KEY, SRLogType.NETWORK_LOG)
        put(TIMESTAMP_KEY, from.startTimestampMs)
    }
}
