package com.instabug.library.networkv2.connection;

import com.instabug.library.Constants;
import com.instabug.library.networkv2.RequestResponse;
import com.instabug.library.networkv2.request.Header;
import com.instabug.library.networkv2.request.Request;
import com.instabug.library.networkv2.request.RequestMethod;
import com.instabug.library.util.InstabugSDKLogger;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.charset.Charset;
import java.util.zip.GZIPOutputStream;

/**
 * An implementation class to manage the connection of the normal application/json requests.
 */
public class NormalConnectionManager extends InstabugBaseConnectionManagerImpl {

    @Override
    public HttpURLConnection setupConnection(HttpURLConnection connection, Request request) throws Exception {
        InstabugSDKLogger.d(Constants.LOG_TAG, "Connect to: " + request.getRequestUrlForLogging() + " with normal type");
        connection.setRequestProperty(Header.CONTENT_ENCODING, "gzip");
        connection.setReadTimeout(getReadTimeOut());
        connection.setConnectTimeout(getConnectTimeOut());
        if (connection.getRequestMethod().equals(RequestMethod.POST) ||
                connection.getRequestMethod().equals(RequestMethod.PUT)) {
            connection.setDoOutput(true);
            writeRequestBody(connection.getOutputStream(), request.getRequestBody());
        }
        return connection;
    }

    @Override
    public String getContentType() {
        return "application/json";
    }

    @Override
    public int getReadTimeOut() {
        return DEFAULT_READ_TIME_OUT;
    }

    @Override
    public int getConnectTimeOut() {
        return DEFAULT_CONNECTION_TIME_OUT;
    }

    @Override
    public RequestResponse handleResponse(HttpURLConnection connection, Request request) throws IOException {
        RequestResponse requestResponse = new RequestResponse();
        if (connection != null) {
            int responseCode = connection.getResponseCode();
            requestResponse.setResponseCode(responseCode);
            requestResponse.setHeaders(getHeaderFields(connection));
            String response = "";
            response = convertStreamToString(connection.getInputStream());
            requestResponse.setResponseBody(response);
            connection.disconnect();
        }
        return requestResponse;
    }

    private void writeRequestBody(OutputStream outputStream, String requestBody) throws
            IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
        gzipOutputStream.write(requestBody.getBytes(Charset.forName("UTF8")));
        gzipOutputStream.close();
        outputStream.write(byteArrayOutputStream.toByteArray());
        try {
            outputStream.flush();
        } catch (Exception exception) {
            InstabugSDKLogger.e(Constants.LOG_TAG, "Failed to flush o/s ", exception);
        } finally {
            byteArrayOutputStream.close();
            outputStream.close();
        }
    }
}
