package com.instabug.library.networkinterception.urlconnection

import com.instabug.library.factory.ParameterizedFactory
import com.instabug.library.internal.servicelocator.Provider
import com.instabug.library.networkinterception.NetworkInterceptionServiceLocator
import com.instabug.library.networkinterception.delegate.NetworkInterceptorDelegate
import com.instabug.library.util.extenstions.runOrLogError
import java.io.InputStream
import java.io.OutputStream
import java.net.URL
import javax.net.ssl.HttpsURLConnection

class IBGHttpsUrlConnectionFactory(
    private val interceptorDelegateProvider: Provider<NetworkInterceptorDelegate<OutputStream, InputStream>?>
) : ParameterizedFactory<IBGHttpsUrlConnection?, Pair<URL, HttpsURLConnection>> {
    override fun create(type: Pair<URL, HttpsURLConnection>): IBGHttpsUrlConnection? =
        runOrLogError {
            interceptorDelegateProvider.invoke()?.let { interceptorDelegate ->
                IBGHttpsUrlConnection(
                    HttpsUrlConnectionInterceptor(
                        type.first,
                        type.second,
                        interceptorDelegate,
                        NetworkInterceptionServiceLocator.processor
                    )
                )
            }
        }.getOrNull()
}
