package com.instabug.library.networkinterception.urlconnection

import com.instabug.library.factory.ParameterizedFactory
import com.instabug.library.internal.servicelocator.Provider
import com.instabug.library.networkinterception.NetworkInterceptionServiceLocator
import com.instabug.library.networkinterception.delegate.NetworkInterceptorDelegate
import com.instabug.library.util.extenstions.runOrLogError
import java.io.InputStream
import java.io.OutputStream
import java.net.HttpURLConnection
import java.net.URL

class IBGHttpUrlConnectionFactory(
    private val interceptorDelegateProvider: Provider<NetworkInterceptorDelegate<OutputStream, InputStream>?>
) : ParameterizedFactory<IBGHttpUrlConnection?, Pair<URL, HttpURLConnection>> {
    override fun create(type: Pair<URL, HttpURLConnection>): IBGHttpUrlConnection? =
        runOrLogError {
            interceptorDelegateProvider.invoke()?.let { interceptorDelegate ->
                IBGHttpUrlConnection(
                    HttpUrlConnectionInterceptor(
                        type.first,
                        type.second,
                        interceptorDelegate,
                        NetworkInterceptionServiceLocator.processor
                    )
                )
            }
        }.getOrNull()
}
