package com.instabug.library.networkinterception.model

open class NetworkLogResponseModel protected constructor() {

    protected constructor(origin: NetworkLogResponseModel) : this() {
        headers = origin.headers
        body = origin.body
        contentLength = origin.contentLength
        responseCode = origin.responseCode
        clientSideThrowable = origin.clientSideThrowable
    }

    var headers: Map<String, String>? = null
        protected set

    var body: String? = null
        protected set

    var contentLength: Long? = null
        protected set

    var responseCode: Int? = null
        protected set

    var clientSideThrowable: Throwable? = null
        protected set

    open fun newBuilder(): Builder =
        Builder(NetworkLogResponseModel(this))

    open class Builder internal constructor(private val holder: NetworkLogResponseModel) {

        constructor() : this(NetworkLogResponseModel())

        fun setHeaders(headers: Map<String, String>?): Builder = apply {
            holder.headers = headers
        }

        val headers: Map<String, String>?
            get() = holder.headers

        fun setBody(body: String?): Builder = apply {
            holder.body = body
        }

        val body: String?
            get() = holder.body

        fun setContentLength(contentLength: Long?): Builder = apply {
            holder.contentLength = contentLength
        }

        val contentLength: Long?
            get() = holder.contentLength

        fun setResponseCode(responseCode: Int?): Builder = apply {
            holder.responseCode = responseCode
        }

        val responseCode: Int?
            get() = holder.responseCode

        fun setClientSideThrowable(clientSideThrowable: Throwable?): Builder = apply {
            holder.clientSideThrowable = clientSideThrowable
        }

        val clientSideThrowable: Throwable?
            get() = holder.clientSideThrowable

        open fun build(): NetworkLogResponseModel = holder
    }
}
