package com.instabug.library.networkinterception.model

open class NetworkLogRequestModel protected constructor() {

    protected constructor (origin: NetworkLogRequestModel) : this() {
        headers = origin.headers
        body = origin.body
        contentLength = origin.contentLength
        method = origin.method
    }

    var headers: Map<String, String>? = null
        protected set

    var body: String? = null
        protected set

    var contentLength: Long? = null
        protected set

    var method: String? = null
        protected set

    open fun newBuilder(): Builder = Builder(NetworkLogRequestModel(this))

    open class Builder internal constructor(private val holder: NetworkLogRequestModel) {
        constructor() : this(NetworkLogRequestModel())

        fun setHeaders(headers: Map<String, String>?): Builder = apply {
            holder.headers = headers
        }

        val headers
            get(): Map<String, String>? = holder.headers

        fun setBody(body: String?): Builder = apply {
            holder.body = body
        }

        val body
            get(): String? = holder.body

        fun setContentLength(contentLength: Long?): Builder = apply {
            holder.contentLength = contentLength
        }

        val contentLength
            get(): Long? = holder.contentLength

        val method: String?
            get() = holder.method

        fun setMethod(method: String?): Builder = apply {
            holder.method = method
        }

        open fun build(): NetworkLogRequestModel = holder
    }
}
