package com.instabug.library.networkinterception.invalidate

import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.util.extenstions.runOrLogError

/**
 * Invalidates headers the are passed through the network with the request by injecting or removing
 * headers to support different sub-features
 * with a [NetworkLogModel.Builder] to retain state and apply side effect logic to
 */
fun interface HeadersInvalidator {
    operator fun invoke(
        headers: MutableMap<String, String>?,
        networkLogBuilder: NetworkLogModel.Builder
    ): MutableMap<String, String>?
}

/**
 * Compose Invalidator that chains multiple invalidators together
 */
class CompositeHeadersInvalidator(
    private val invalidators: List<HeadersInvalidator>
) : HeadersInvalidator {

    override fun invoke(
        headers: MutableMap<String, String>?,
        networkLogBuilder: NetworkLogModel.Builder
    ) = runOrLogError {
        invalidators.fold(headers) { headers, invalidator ->
            invalidator(headers, networkLogBuilder)
        }
    }.getOrElse { headers }
}
