package com.instabug.library.networkinterception.grpc.model

import com.instabug.library.networkinterception.model.NetworkLogResponseModel

class GrpcNetworkLogResponseModel : NetworkLogResponseModel {

    private constructor() : super()
    private constructor(origin: NetworkLogResponseModel) : super(origin) {
        if (origin is GrpcNetworkLogResponseModel) {
            clientErrorCode = origin.clientErrorCode
            clientErrorMessage = origin.clientErrorMessage
            serverErrorMessage = origin.serverErrorMessage
        }
    }

    var clientErrorCode: Int? = null
        private set

    var clientErrorMessage: String? = null
        private set

    var serverErrorMessage: String? = null
        private set

    override fun newBuilder(): Builder = Builder(GrpcNetworkLogResponseModel(this))

    class Builder internal constructor(
        private val holder: GrpcNetworkLogResponseModel
    ) : NetworkLogResponseModel.Builder(holder) {

        constructor() : this(GrpcNetworkLogResponseModel())

        fun setClientErrorCode(clientErrorCode: Int?): Builder = apply {
            holder.clientErrorCode = clientErrorCode
        }

        val clientErrorCode: Int?
            get() = holder.clientErrorCode

        fun setClientErrorMessage(clientErrorMessage: String?): Builder = apply {
            holder.clientErrorMessage = clientErrorMessage
        }

        val clientErrorMessage: String?
            get() = holder.clientErrorMessage

        fun setServerErrorMessage(serverErrorMessage: String?): Builder = apply {
            holder.serverErrorMessage = serverErrorMessage
        }

        val serverErrorMessage: String?
            get() = holder.serverErrorMessage

        override fun build(): GrpcNetworkLogResponseModel = holder
    }
}
