package com.instabug.library.networkinterception.grpc.model

import com.instabug.library.networkinterception.model.NetworkLogRequestModel

class GrpcNetworkLogRequestModel : NetworkLogRequestModel {

    private constructor() : super()
    private constructor (origin: NetworkLogRequestModel) : super(origin) {
        if (origin is GrpcNetworkLogRequestModel) {
            method = origin.method
        }
    }

    var grpcMethod: String? = null
        private set

    override fun newBuilder(): Builder = Builder(GrpcNetworkLogRequestModel(this))

    class Builder internal constructor(
        private val holder: GrpcNetworkLogRequestModel
    ) : NetworkLogRequestModel.Builder(holder) {

        constructor() : this(GrpcNetworkLogRequestModel())

        fun setGRPCMethod(grpcMethod: String?): Builder = apply {
            holder.grpcMethod = grpcMethod
        }

        val grpcMethod: String?
            get() = holder.grpcMethod

        override fun build(): GrpcNetworkLogRequestModel = holder
    }
}
