package com.instabug.library.networkinterception.gql.model

import com.instabug.library.networkinterception.model.NetworkLogRequestModel

class GqlNetworkLogRequestModel : NetworkLogRequestModel {

    private constructor() : super()
    private constructor (origin: NetworkLogRequestModel) : super(origin) {
        if (origin is GqlNetworkLogRequestModel) {
            query = origin.query
        }
    }

    var query: String? = null
        private set

    override fun newBuilder(): Builder =
        Builder(GqlNetworkLogRequestModel(this))

    class Builder internal constructor(
        private val holder: GqlNetworkLogRequestModel
    ) : NetworkLogRequestModel.Builder(holder) {

        constructor() : this(GqlNetworkLogRequestModel())
        constructor(baseModel: NetworkLogRequestModel) : this(GqlNetworkLogRequestModel(baseModel))

        fun setQuery(query: String?): Builder = apply {
            holder.query = query
        }

        val query: String?
            get() = holder.query

        override fun build(): GqlNetworkLogRequestModel = holder
    }
}
