package com.instabug.library.networkinterception.gql

import com.instabug.library.map.Mapper
import com.instabug.library.networkinterception.config.IBGNetworkInterceptionConfigurationProvider
import com.instabug.library.networkinterception.util.lcApolloGQLQuery
import com.instabug.library.networkinterception.util.toLowerCaseKeys

class GqlHeaderToQueryMapper(
    private val configurations: IBGNetworkInterceptionConfigurationProvider
) : Mapper<Map<String, String>, String?> {
    override fun map(from: Map<String, String>): String? =
        from.takeIf { configurations.v2GqlFeatureAvailable }?.toLowerCaseKeys()?.lcApolloGQLQuery()
}
