package com.instabug.library.networkinterception.externaltrace

import com.instabug.library.factory.ParameterizedFactory
import com.instabug.library.networkinterception.invalidate.HeadersInvalidator
import com.instabug.library.networkinterception.model.NetworkLogModel
import com.instabug.library.networkinterception.model.NetworkLogW3CExternalTraceIdInfo

class W3CHeadersInvalidator(
    private val w3cHeadersFactor: ParameterizedFactory<NetworkLogW3CExternalTraceIdInfo?, Map<String, String>?>
) : HeadersInvalidator {
    // TODO remove this variable to enable w3c headers feature
    private val enableW3CHeaders = false
    override fun invoke(
        headers: MutableMap<String, String>?,
        networkLogBuilder: NetworkLogModel.Builder
    ): MutableMap<String, String>? =
        if (enableW3CHeaders) {
            w3cHeadersFactor.takeIf { networkLogBuilder.injectableHeaders == null }
                ?.create(headers)
                ?.also { networkLogBuilder.setInjectableHeaders(it) }
                ?.headers
                ?.let { headers.addAll(it) } ?: headers
        } else {
            headers
        }

    private fun MutableMap<String, String>?.addAll(
        other: Map<String, String>?
    ): MutableMap<String, String>? =
        other?.let {
            this?.apply { putAll(it) } ?: HashMap(it)
        } ?: this
}
